% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputProcessingUtilties.R
\name{downsample}
\alias{downsample}
\title{Occurrence downsampling}
\usage{
downsample(occs, rasterTemplate, verbose = TRUE)
}
\arguments{
\item{occs}{A \code{data.frame} with at least two columns
named "longitude" and "latitude" or that
can be coerced into this format.}

\item{rasterTemplate}{A \code{SpatRaster} object to serve
as a template for the resolution at which \code{occs} should be
downsampled.}

\item{verbose}{\code{logical}. Switching to \code{FALSE} mutes message describing
which columns in \code{occs} are interpreted as x and y coordinates.}
}
\value{
A \code{data.frame} with two columns named "longitude"
and "latitude" or with names that were used when coercing
input data into this format.
}
\description{
Reduces number of occurrences to resolution of input raster
}
\examples{
library(terra)
# Create sample raster
r <- rast(ncol=10, nrow=10)
values(r) <- 1:100

# Create test occurrences
set.seed(0)
longitude <- sample(ext(r)[1]:ext(r)[2],
                    size = 10, replace = FALSE)
set.seed(0)
latitude <- sample(ext(r)[3]:ext(r)[4],
                   size = 10, replace = FALSE)
occurrences <- as.data.frame(cbind(longitude,latitude))

# Here's the function
result <- downsample(occs = occurrences, rasterTemplate = r)

}
\keyword{inputProcessing}
