% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_rand_zonotope.R
\name{gen_rand_zonotope}
\alias{gen_rand_zonotope}
\title{Generator function for zonotopes}
\usage{
gen_rand_zonotope(dimension, nsegments, generator = NULL, seed = NULL)
}
\arguments{
\item{dimension}{The dimension of the zonotope.}

\item{nsegments}{The number of segments that generate the zonotope.}

\item{generator}{The distribution to pick the length of each segment from \eqn{[0,100]}: (a) 'uniform', (b) 'gaussian' or (c) 'exponential'.}

\item{seed}{Optional. A fixed seed for the generator.}
}
\value{
A polytope class representing a zonotope.
}
\description{
This function generates a random \eqn{d}-dimensional zonotope defined by the Minkowski sum of \eqn{m} \eqn{d}-dimensional segments.
The function considers \eqn{m} random directions in \eqn{R^d}. There are three strategies to pick the length of each segment: a) it is uniformly sampled from \eqn{[0,100]}, b) it is random from \eqn{\mathcal{N}(50,(50/3)^2)} truncated to \eqn{[0,100]}, c) it is random from \eqn{Exp(1/30)} truncated to \eqn{[0,100]}.
}
\examples{
# generate a 10-dimensional zonotope defined by the Minkowski sum of 20 segments
P = gen_rand_zonotope(10, 20)
}
