% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{copula2}
\alias{copula2}
\title{Construct a copula using uniform sampling from the unit simplex}
\usage{
copula2(h, E, numSlices, N)
}
\arguments{
\item{h}{A \eqn{d}-dimensional vector that describes the direction of the first family of parallel hyperplanes.}

\item{E}{The \eqn{d\times d} symmetric positive semidefine matrix that describes the family of concentric ellipsoids centered at the origin.}

\item{numSlices}{The number of the slices for the copula. Default value is 100.}

\item{N}{The number of points to sample. Default value is \eqn{4\cdot 10^6}.}
}
\value{
A \eqn{numSlices\times numSlices} numerical matrix that corresponds to a copula.
}
\description{
Given a family of parallel hyperplanes and a family of concentric ellispoids centered at the origin intersecting the canonical simplex, this function uniformly samples from the canonical simplex and construct an approximation of the bivariate probability distribution, called copula.
}
\examples{
# compute a copula for a family of parallel hyperplanes and a family of conentric ellipsoids
h = runif(n = 10, min = 1, max = 1000)
h = h / 1000
E = replicate(10, rnorm(20))
E = cov(E)
cop = copula2(h=h, E=E, numSlices=10, N=100000)
}
\references{
\cite{L. Cales, A. Chalkis, I.Z. Emiris, V. Fisikopoulos,
\dQuote{Practical volume computation of structured convex bodies, and an application to modeling portfolio dependencies and financial crises,} \emph{Proc. of Symposium on Computational Geometry, Budapest, Hungary,} 2018.}
}
