% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_animation.R
\name{add_animation}
\alias{add_animation}
\title{Add mode bar button to rotate the plot}
\usage{
add_animation(
  p,
  rotate_icon_path = NULL,
  stop_icon_path = NULL,
  rotate_colour = "#c7c7c7",
  stop_colour = "#ff6347",
  scale = "scale(0.4) translate(-4, -4)",
  speed = 320,
  shiny_event_names = c()
)
}
\arguments{
\item{p}{The volcano3D plot}

\item{rotate_icon_path}{The svg icon path for rotation. If NULL a play 
button is used}

\item{stop_icon_path}{The svg icon path for stop button. If NULL a pause 
button is used}

\item{rotate_colour}{The colour for the rotate button (default="#c7c7c7")}

\item{stop_colour}{The colour for the stop button (default='#ff6347', 
a.k.a 'tomato')}

\item{scale}{Scaling for rotation button}

\item{speed}{The rotation speed}

\item{shiny_event_names}{If using shiny, pass in any shiny event names which
should stop rotation when triggered (e.g. shiny_event_names = c('replot'))}
}
\value{
Returns a rotating cylindrical 3D plotly plot featuring variables on 
a tri-axis radial graph with the -log10(multi-group test p-value) on the 
z-axis
}
\description{
Add mode bar button to rotate the plot
}
\examples{
data(example_data)
syn_polar <- polar_coords(outcome = syn_example_meta$Pathotype,
                          data = t(syn_example_rld))

p <- volcano3D(syn_polar, 
    label_rows = c("COBL", "TREX2"))
add_animation(p)

}
\references{
Lewis, Myles J., et al. (2019).
\href{https://pubmed.ncbi.nlm.nih.gov/31461658/}{
Molecular portraits of early rheumatoid arthritis identify clinical and 
treatment response phenotypes.}
\emph{Cell reports}, \strong{28}:9
}
\concept{volcanoplot}
\keyword{hplot}
\keyword{iplot}
