% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_domain_score.R
\name{nn_domain_score}
\alias{nn_domain_score}
\title{Calculate the Neural Network model domain applicability score}
\usage{
nn_domain_score(
  featured_col,
  train_data,
  nn_hyperparameters,
  test_data,
  threshold_value
)
}
\arguments{
\item{featured_col}{The name of the featured column in the training data.}

\item{train_data}{The training data used to fit the Neural Network model.}

\item{nn_hyperparameters}{A list of Neural Network hyperparameters, including hidden_units, penalty, and epochs.}

\item{test_data}{The testing domain data used to calculate the domain applicability score.}

\item{threshold_value}{The threshold value for domain applicability scoring.}
}
\value{
A tibble with the domain applicability scores.
}
\description{
This function fits a Neural Network model to the provided data and computes a
domain applicability score based on PCA distances.
}
\examples{
set.seed(123)
library(dplyr)
featured_col <- "cd_2022"
# Specifying features for training and testing procedures
train_data = viral |>
  dplyr::select(cd_2022, vl_2022)
test_data = sero 
nn_hyperparameters <- list(hidden_units = 1, penalty = 0.3746312,  epochs =  480)
threshold_value <- 0.99
# Call the function
}
