% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-statespace.R
\name{plot.statespace}
\alias{plot.statespace}
\title{Plot a statespace object}
\usage{
\method{plot}{statespace}(x, pause = FALSE, window_size = 7, date = NULL, sel = NULL, ...)
}
\arguments{
\item{x}{the statespace object.}

\item{pause}{(default \code{FALSE}) if set to \code{FALSE} then the plots are displayed on a single
page, otherwise a new page is created for each plot.}

\item{window_size}{(default \code{7}) the window size of the rolling mean computed on the
error to display the bias, and on the mean squared error to display a rolling RMSE.}

\item{date}{(default \code{NULL}) defines the values for the x-axis.}

\item{sel}{(default \code{NULL}) defines a subset of the data on which we zoom.
For instance one can display the evolution of the SSM on a test set and not the whole data set.}

\item{...}{additional parameters}
}
\value{
No return value, called to display plots.
}
\description{
\code{plot.statespace} displays different graphs expressing the behavior of the state-space
model:\cr
1. Evolution of the Bias: rolling version of the error of the model.\cr
2. Evolution of the RMSE: root-mean-square-error computed on a rolling window.\cr
3. State Evolution: time-varying state coefficients, subtracted of the initial state vector.\cr
4. Normal Q-Q Plot: we check if the observation follows the Gaussian distribution of estimated
mean and variance. To that end, we display a Q-Q plot of the residual divided by the estimated
standard deviation, against the standard normal distribution.\cr
}
