% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Downsample_scene.R
\name{downsample_scene}
\alias{downsample_scene}
\title{Reduces the point cloud density}
\usage{
downsample_scene(data, method, filter)
}
\arguments{
\item{data}{LAS file of a 3D point cloud.}

\item{method}{character string. Defines the method to use for downsampling.
Can be "space" or "random". See details. Default = "space".}

\item{filter}{numeric. The intensity of the filter that depends on the
method. See details.}
}
\value{
The downsampled data.
}
\description{
Reduces the point cloud density
}
\details{
\subsection{\code{method = "space"}}{
a single point is conserved within a voxel of
\code{filter} size.}
\subsection{\code{method = "random"}}{
randomly select a user defined proportion of the point cloud.
Here, \code{filter} is the proportion of points to keep in the point cloud.}
}
\examples{
\donttest{
#- import the tree_line_plot dataset
file <- system.file("extdata", "tree_line_plot.laz", package="viewshed3d")
tls <- lidR::readLAS(file,select="xyz")

#- reduce the point cloud density: keep one point in a voxel of 4cm.
sub = viewshed3d::downsample_scene(tls,filter=0.04)

#- plot the downsampled point cloud
lidR::plot(sub)
}
}
