% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_viewmetrics.R
\name{calculate_viewmetrics}
\alias{calculate_viewmetrics}
\title{calculate_viewmetrics}
\usage{
calculate_viewmetrics(viewshed, dsm, dtm, masks = list())
}
\arguments{
\item{viewshed}{Viewshed object.}

\item{dsm}{Raster, Digital Surface Model for the calculation of}

\item{dtm}{Raster, Digital Terrain Model}

\item{masks}{List, a list including rasters of canopy and building footprints.
For example of canopy raster, the value for cells without canopy should be 0 and
the value for cells with canopy can be any number.}
}
\value{
List
}
\description{
The calculate_viewmetrics function is designed to compute a set of
configuration metrics based on a given viewshed object and optionally, digital surface
models (DSM) and digital terrain models (DTM) for terrain analysis.
The function calculates various metrics that describe the visibility characteristics
of a landscape from a specific viewpoint.The metrics include:
\enumerate{
\item Extent: The total area of the viewshed, calculated as the number of visible grid
cells multiplied by the grid resolution
\item Depth: The furthest visible distance within the viewshed from the viewpoint
\item Vdepth: The standard deviation of distances to visible points,
providing a measure of the variation in visible distances
\item Horizontal: The total visible horizontal or terrestrial area within the viewshed
\item Relief: The standard deviation of elevations of the visible ground surface
\item Skyline: The standard deviation of the vertical viewscape, including visible
canopy and buildings, when specified
\item Number of patches: Visible fragmentation measured by total visible patches
with the viewscape
\item Mean shape index: Visible patchiness based on average perimeter-to-area ratio
for all viewscape patches (vegetation and building)
\item Edge density: A measure of visible complexity based on the length of
patch edges per unit area
\item Patch size: Total average size of a patches over the entire viewscape area
\item Patch density: Visible landscape granularity based on measuring patch density
\item Shannon diversity index: The abundance and evenness of land cover/use in a viewshed
\item Proportion of object: Proportion of a single type of land use or cover in a viewshed
}
}
\examples{
\donttest{
# Load in DSM
test_dsm <- terra::rast(system.file("test_dsm.tif",
                                    package ="viewscape"))
# Load DTM
test_dtm <- terra::rast(system.file("test_dtm.tif",
                                    package ="viewscape"))

# Load canopy raster
test_canopy <- terra::rast(system.file("test_canopy.tif",
                                       package ="viewscape"))

# Load building footprints raster
test_building <- terra::rast(system.file("test_building.tif",
                                         package ="viewscape"))

# Load in the viewpoint
test_viewpoint <- sf::read_sf(system.file("test_viewpoint.shp",
                                          package = "viewscape"))

# Compute viewshed
output <- viewscape::compute_viewshed(dsm = test_dsm,
                                      viewpoints = test_viewpoint,
                                      offset_viewpoint = 6)

# calculate metrics given the viewshed, canopy, and building footprints
test_metrics <- viewscape::calculate_viewmetrics(output,
                                                 test_dsm,
                                                 test_dtm,
                                                 list(test_canopy, test_building))
}

}
\references{
Tabrizian, P., Baran, P.K., Berkel, D.B., Mitásová, H., & Meentemeyer, R.K. (2020).
Modeling restorative potential of urban environments by coupling viewscape analysis of lidar
data with experiments in immersive virtual environments. Landscape and Urban Planning, 195, 103704.
}
