% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VirtualArray-subset.R
\name{subset,VirtualArray-method}
\alias{subset,VirtualArray-method}
\title{Subset a '\code{\link[via:XArray-class]{VirtualArray}}'-class object}
\usage{
\S4method{subset}{VirtualArray}(x, i, j, ..., oneDim = FALSE, drop = TRUE)
}
\arguments{
\item{x}{\code{\link[via:XArray-class]{VirtualArray}}-class object.}

\item{i}{subscript of the first dimension(rows) or vector-like subsetting.}

\item{j}{subscript of the second dimension (columns).}

\item{...}{subscript of additional dimensions.}

\item{oneDim}{\code{logical} In case of multidimensional \code{\link[via:XArray-class]{VirtualArray}}s, setting \code{oneDim} to \code{TRUE} allows the application of one dimensional subscripts.}

\item{drop}{\code{logical} in case the result of subsetting is a single element, should the \\code{\link[via:XArray-class]{VirtualArray}} wrapper be dropped?}
}
\value{
Either the same class as \code{x}, or the class that forms the element of the \code{\link[via:XArray-class]{VirtualArray}}.
}
\description{
Extract subsets of an object from a class derived from '\code{\link[via:XArray-class]{VirtualArray}}' similarly to a regular array.
}
\examples{
ex <- rastex()
# first 4
subset(ex, i=1:4)
# missing at the end
subset(ex, i=1:12)
# character subscript
subset(ex, i=c("a", "b"))
# logical subscript
subs <- rep(TRUE, length(ex))
subs[1] <- FALSE # remove first
subset(ex, i= subs)
# no drop
subset(ex, i=1, drop=FALSE)
}
