% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{RasterArray-class}
\alias{RasterArray-class}
\alias{RasterArray}
\title{Array of '\code{\link[terra:rast]{SpatRaster}}'-class objects}
\arguments{
\item{stack}{A \code{\link[terra:rast]{SpatRaster}} object.}

\item{index}{A \code{vector}, \code{matrix} or \code{array} type object. Includes either the indices of layers in the stack, or their names.}

\item{dim}{A \code{numeric} vector. Same as for \code{array}, creates \code{proxy} procedurally.}
}
\value{
A '\code{\link[via:RasterArray-class]{RasterArray}}'-class object.
}
\description{
Array class for easier navigation of multilayer rasters
}
\details{
The class implements structures to organize single-layer '\code{\link[terra:rast]{SpatRaster}}'-class objects that have the same dimensions and coordinate reference system. Subsetting rules were defined using the proxy object in the \code{@index} slot. See examples for implementations.

The class has two slots:
\code{@stack}: A '\code{\link[terra:rast]{SpatRaster}}'-class object with multiple layers, the actual data.
\code{index}: A proxy object that represents the organization of the layer in the array.
}
\examples{
# example data
  ex <- rastex()
  st <-ex@stack
  ind <- 1:6
  names(ind) <- letters[1:length(ind)]
  ra<- RasterArray(stack=st, index=ind)
  
}
