% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EmissionsList.R, R/Evaporative.R, R/ef_ive.R,
%   R/emis_source.R, R/emis_wrf.R, R/hot_soak.R, R/running_losses.R,
%   R/vein-deprecated.R
\name{vein-deprecated}
\alias{vein-deprecated}
\alias{EmissionsList}
\alias{print.EmissionsList}
\alias{summary.EmissionsList}
\alias{plot.EmissionsList}
\alias{Evaporative}
\alias{print.Evaporative}
\alias{summary.Evaporative}
\alias{plot.Evaporative}
\alias{ef_ive}
\alias{emis_source}
\alias{emis_wrf}
\alias{hot_soak}
\alias{running_losses}
\title{DEPRECATED Construction function for class "EmissionsList"}
\usage{
EmissionsList(x, ...)

Evaporative(x, ...)

ef_ive(
  description = "Auto/Sml Truck",
  fuel = "Petrol",
  weight = "Light",
  air_fuel_control = "Carburetor",
  exhaust = "None",
  evaporative = "PCV",
  mileage,
  pol,
  details = FALSE
)

emis_source(
  path = "est",
  pattern = ".R",
  ignore = "~",
  first,
  ask = TRUE,
  recursive = TRUE,
  full.names = TRUE,
  echo = FALSE
)

emis_wrf(sdf, nr = 1, dmyhm, tz, crs = 4326, islist)

hot_soak(x, carb, p, eshotc, eswarmc, eshotfi)

running_losses(x, erhotfi, lkm, carb, p, erhotc, erwarmc)
}
\arguments{
\item{x}{Object with class "numeric"}

\item{...}{ignored}

\item{description}{Character; "Auto/Sml Truck" "Truck/Bus" or"Sml Engine".}

\item{fuel}{Character; "Petrol", "NG Retrofit", "Natural Gas", "Prop Retro.",
"Propane", "EthOH Retrofit", "OEM Ethanol", "Diesel", "Ethanol" or "CNG/LPG".}

\item{weight}{Character; "Light", "Medium", "Heavy", "Lt", "Med" or "Hvy"}

\item{air_fuel_control}{Character; One of the following characters: "Carburetor",
"Single-Pt FI", "Multi-Pt FI", "Carb/Mixer", "FI", "Pre-Chamber Inject.",
"Direct Injection", "2-Cycle", "2-Cycle, FI", "4-Cycle, Carb", "4-Cycle, FI"
"4-Cycle"}

\item{exhaust}{Character: "None", "2-Way", "2-Way/EGR", "3-Way", "3-Way/EGR",
"None/EGR", "LEV", "ULEV", "SULEV", "EuroI", "EuroII", "EuroIII", "EuroIV",
"Hybrid", "Improved", "EGR+Improv", "Particulate", "Particulate/NOx",
"EuroV", "High Tech" or "Catalyst"}

\item{evaporative}{Character: "PCV", "PCV/Tank" or"None".}

\item{mileage}{Numeric; mileage of vehicle by age of use km.}

\item{pol}{Character; One of the following characters: "Carburetor",
"Single-Pt FI", "Multi-Pt FI", "Carb/Mixer", "FI", "Pre-Chamber Inject.",
"Direct Injection", "2-Cycle", "2-Cycle, FI", "4-Cycle, Carb", "4-Cycle, FI"
"4-Cycle"
#' \tabular{cccc}{
  "VOC_gkm" \tab "CO_gkm" \tab "NOx_gkm" \tab "PM_gkm" \cr
  "Pb_gkm" \tab "SO2_gkm" \tab "NH3_gkm" \tab "1,3-butadiene_gkm" \cr
  "formaldehyde_gkm" \tab "acetaldehyde_gkm" \tab "benzene_gkm" \tab "EVAP_gkm" \cr
  "CO2_gkm" \tab "N20_gkm" \tab "CH4_gkm" \tab "VOC_gstart" \cr
  "CO_gstart" \tab "NOx_gstart" \tab "PM_gstart" \tab "Pb_gstart" \cr
  "SO2_gstart" \tab "NH3_gstart" \tab "1,3-butadiene_gstart" \tab "formaldehyde_gstart" \cr
  "acetaldehyde_gstart" \tab "benzene_gstart" \tab "EVAP_gstart" \tab "CO2_gstart" \cr
  "N20_gstart" \tab "CH4_gstart" \tab   \tab  \cr
}}

\item{details}{Logical; option to see or not more information about vehicle.}

\item{path}{Character; path to source scripts. Default is "est".}

\item{pattern}{Character; extensions of R scripts. Default is ".R".}

\item{ignore}{Character; character to be excluded. Default is "~". Sometimes,
the OS creates automatic back-ups, for instance "run.R~", the idea is to
avoid sourcing these files.}

\item{first}{Character; first script.}

\item{ask}{Logical; Check inputs or not. Default is "FALSE". It allows to
stop inputs}

\item{recursive}{Logical; recursive or not. Default is "TRUE"}

\item{full.names}{Logical; full.names or not. Default is "TRUE".}

\item{echo}{Source with echo?}

\item{sdf}{Gridded emissions, which can be a SpatialPolygonsDataFrame, or a list
of SpatialPolygonsDataFrame, or a sf object of "POLYGON". The user must enter
a list with 36 SpatialPolygonsDataFrame with emissions for the mechanism CBMZ.}

\item{nr}{Number of repetitions of the emissions period}

\item{dmyhm}{String indicating Day Month Year Hour and Minute in the format
"d-m-Y H:M" e.g.: "01-05-2014 00:00" It represents the time of the first
hour of emissions in Local Time}

\item{tz}{Time zone as required in for function \code{\link{as.POSIXct}}}

\item{crs}{Coordinate reference system, e.g: "+init=epsg:4326". Used to
transform the coordinates of the output}

\item{islist}{logical value to indicate if sdf is a list or not}

\item{object}{Object with class "Evaporative"}
}
\value{
Objects of class "EmissionsList" and numeric elements as "units"

Objects of class "Evaporative" or "units"

An emission factor by annual mileage.
}
\description{
\code{EmissionsList} returns a transformed object with class "EmissionsList".

\code{Evaporative} returns a transformed object with class "Evaporative" and
units g. This class represents the daily emissions presented by
Mellios G and Ntziachristos (2016) Gasoline evaporation, Tier 2. Eventually
it will be incorporated the techniques of Tier 3.

This function was deprecated. If the user want some UF-based EF, run MOVES
and extract EF

\code{\link{emis_source}} source vein scripts

\code{emis_wrf} returns a dataframe with columns lat, long, id, pollutants, local time
and GMT time. This dataframe has the proper format to be used with WRF
assimilation system: "ASimilation System 4 WRF (AS4WRF Vera-Vala et al (2016))

The functions listed below are deprecated and will be defunct in
  the near future. When possible, alternative functions with similar
  functionality are also mentioned. Help pages for deprecated functions are
  available at \code{help("-deprecated")}.
}
\details{
\code{\link{ef_ive}} returns the base emission factors from the the IVE
model. This function depend on vectorized mileage, which means your can
enter with the mileage by age of use and the name of the pollutant.
}
\section{\code{Evaporative}}{

For \code{Evaporative}, use \code{\link{emis_evap}}.


For \code{running_losses}, use \code{\link{emis_evap}}.


For \code{running_losses}, use \code{\link{emis_evap}}.
}

\examples{
\dontrun{
# do not run
# DEPRECATED
}
\dontrun{
# do not run
# DEPRECATED
}
\dontrun{
# Do not run
# Passenger Cars PC
data(fkm)
# cumulative mileage from 1 to 50 years of use, 40:50
mil <- cumsum(fkm$KM_PC_E25(1:50))
ef_ive("Truck/Bus", mileage = mil, pol = "CO_gkm")
ef_ive(mileage = mil, pol = "CO_gkm", details = TRUE)
}
\dontrun{
# Do not run
}
\dontrun{
# do not run
# Use library(eixport)
# eixport::to_as4wrf()
}
\dontrun{
# Do not run
}
\dontrun{
# Do not run
}

}
\references{
Nicole Davis, James Lents, Mauricio Osses, Nick Nikkila,
 Matthew Barth. 2005. Development and Application of an International
 Vehicle Emissions Model. Transportation Research Board, 81st Annual Meeting,
 January 2005, Washington, D.C.

Mellios G and Ntziachristos 2016. Gasoline evaporation. In:
EEA, EMEP. EEA air pollutant emission inventory guidebook-2009. European
Environment Agency, Copenhagen, 2009

Mellios G and Ntziachristos 2016. Gasoline evaporation. In:
EEA, EMEP. EEA air pollutant emission inventory guidebook-2009. European
Environment Agency, Copenhagen, 2009
}
\seealso{
\code{\link{vein-deprecated}}

\code{\link{vein-deprecated}}

\code{\link{vein-deprecated}}
}
\keyword{emission}
\keyword{factors}
\keyword{internal}
\keyword{ive}
\keyword{speed}
