% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanspv.R
\name{meanspv}
\alias{expmat}
\alias{meanspv}
\title{Compute Mean Spherical SPV}
\usage{
meanspv(formula, radii, FtF.inv, n)

expmat(formula)
}
\arguments{
\item{formula}{model formula}

\item{radii}{numeric vector or radii at which to calculate the matrix of spherical region moments}

\item{FtF.inv}{inverse of F'F, where F is the design matrix}

\item{n}{integer giving the number of design runs}
}
\description{
Computes the matrix of spherical region moments for a given model formula and a vector of radii, and uses this to
calculate the mean spherical SPV for each of the radii. The function \code{expmat} calculates
the matrix containing the exponents of each model factor within each model term as columns. 
Only simple formulae are allowed for. Only products of terms should be included in
calls to \code{\link{I}}. The power operator \code{\link{^}} should be used instead
of \code{\link{sqrt}}. Models should contain only monomial terms.
}
\examples{
f1 <- formula(~ x1*x2)
expmat(f1)
f2 <- update(f1, ~ . + I(x1^2) + I(x2^2))
expmat(f2)
f3 <- update(f2, ~ . + I(x2^0.4))
expmat(f3)
f4 <- update(f3, ~ . + I(x1^2):I(x2^2))
expmat(f4)
f5 <- update(f4, ~ . + I(x1^3*x2^0.5))
expmat(f5)
}
\author{
Pieter C. Schoonees
}
\references{
Pieter C. Schoonees, Niel J. le Roux, Roelof L.J. Coetzer (2016). Flexible Graphical Assessment of 
Experimental Designs in R: The vdg Package. \emph{Journal of Statistical Software}, 74(3), 1-22. 
 \doi{10.18637/jss.v074.i03}.
}

