% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/names.R
\name{vec_as_names}
\alias{vec_as_names}
\title{Retrieve and repair names}
\usage{
vec_as_names(
  names,
  ...,
  repair = c("minimal", "unique", "universal", "check_unique"),
  repair_arg = "",
  quiet = FALSE,
  call = caller_env()
)
}
\arguments{
\item{names}{A character vector.}

\item{...}{These dots are for future extensions and must be empty.}

\item{repair}{Either a string or a function. If a string, it must
be one of \code{"check_unique"}, \code{"minimal"}, \code{"unique"}, or \code{"universal"}.
If a function, it is invoked with a vector of minimal names and must
return minimal names, otherwise an error is thrown.
\itemize{
\item Minimal names are never \code{NULL} or \code{NA}. When an element doesn't
have a name, its minimal name is an empty string.
\item Unique names are unique. A suffix is appended to duplicate
names to make them unique.
\item Universal names are unique and syntactic, meaning that you can
safely use the names as variables without causing a syntax
error.
}

The \code{"check_unique"} option doesn't perform any name repair.
Instead, an error is raised if the names don't suit the
\code{"unique"} criteria.}

\item{repair_arg}{If specified and \code{repair = "check_unique"}, any errors
will include a hint to set the \code{repair_arg}.}

\item{quiet}{By default, the user is informed of any renaming
caused by repairing the names. This only concerns unique and
universal repairing. Set \code{quiet} to \code{TRUE} to silence the
messages.

Users can silence the name repair messages by setting the
\code{"rlib_name_repair_verbosity"} global option to \code{"quiet"}.}

\item{call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\description{
\code{vec_as_names()} takes a character vector of names and repairs it
according to the \code{repair} argument. It is the r-lib and tidyverse
equivalent of \code{\link[base:make.names]{base::make.names()}}.

vctrs deals with a few levels of name repair:
\itemize{
\item \code{minimal} names exist. The \code{names} attribute is not \code{NULL}. The
name of an unnamed element is \code{""} and never \code{NA}. For instance,
\code{vec_as_names()} always returns minimal names and data frames
created by the tibble package have names that are, at least,
\code{minimal}.
\item \code{unique} names are \code{minimal}, have no duplicates, and can be used
where a variable name is expected. Empty names, \code{...}, and
\code{..} followed by a sequence of digits are banned.
\itemize{
\item All columns can be accessed by name via \code{df[["name"]]} and
\code{df$`name` } and \code{with(df, `name`)}.
}
\item \code{universal} names are \code{unique} and syntactic (see Details for
more).
\itemize{
\item Names work everywhere, without quoting: \code{df$name} and \code{with(df, name)} and \code{lm(name1 ~ name2, data = df)} and
\code{dplyr::select(df, name)} all work.
}
}

\code{universal} implies \code{unique}, \code{unique} implies \code{minimal}. These
levels are nested.
}
\section{\code{minimal} names}{


\code{minimal} names exist. The \code{names} attribute is not \code{NULL}. The
name of an unnamed element is \code{""} and never \code{NA}.

Examples:

\if{html}{\out{<div class="sourceCode">}}\preformatted{Original names of a vector with length 3: NULL
                           minimal names: "" "" ""

                          Original names: "x" NA
                           minimal names: "x" ""
}\if{html}{\out{</div>}}
}

\section{\code{unique} names}{


\code{unique} names are \code{minimal}, have no duplicates, and can be used
(possibly with backticks) in contexts where a variable is
expected. Empty names, \code{...}, and \code{..} followed by a sequence of
digits are banned. If a data frame has \code{unique} names, you can
index it by name, and also access the columns by name. In
particular, \code{df[["name"]]} and \code{df$`name`} and also \code{with(df, `name`)} always work.

There are many ways to make names \code{unique}. We append a suffix of the form
\code{...j} to any name that is \code{""} or a duplicate, where \code{j} is the position.
We also change \code{..#} and \code{...} to \code{...#}.

Example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{Original names:     ""     "x"     "" "y"     "x"  "..2"  "..."
  unique names: "...1" "x...2" "...3" "y" "x...5" "...6" "...7"
}\if{html}{\out{</div>}}

Pre-existing suffixes of the form \code{...j} are always stripped, prior
to making names \code{unique}, i.e. reconstructing the suffixes. If this
interacts poorly with your names, you should take control of name
repair.
}

\section{\code{universal} names}{


\code{universal} names are \code{unique} and syntactic, meaning they:
\itemize{
\item Are never empty (inherited from \code{unique}).
\item Have no duplicates (inherited from \code{unique}).
\item Are not \code{...}. Do not have the form \code{..i}, where \code{i} is a
number (inherited from \code{unique}).
\item Consist of letters, numbers, and the dot \code{.} or underscore \verb{_}
characters.
\item Start with a letter or start with the dot \code{.} not followed by a
number.
\item Are not a \link{reserved} word, e.g., \code{if} or \code{function} or \code{TRUE}.
}

If a vector has \code{universal} names, variable names can be used
"as is" in code. They work well with nonstandard evaluation, e.g.,
\code{df$name} works.

vctrs has a different method of making names syntactic than
\code{\link[base:make.names]{base::make.names()}}. In general, vctrs prepends one or more dots
\code{.} until the name is syntactic.

Examples:

\if{html}{\out{<div class="sourceCode">}}\preformatted{ Original names:     ""     "x"    NA      "x"
universal names: "...1" "x...2" "...3" "x...4"

  Original names: "(y)"  "_z"  ".2fa"  "FALSE"
 universal names: ".y." "._z" "..2fa" ".FALSE"
}\if{html}{\out{</div>}}
}

\examples{
# By default, `vec_as_names()` returns minimal names:
vec_as_names(c(NA, NA, "foo"))

# You can make them unique:
vec_as_names(c(NA, NA, "foo"), repair = "unique")

# Universal repairing fixes any non-syntactic name:
vec_as_names(c("_foo", "+"), repair = "universal")
}
\seealso{
\code{\link[rlang:names2]{rlang::names2()}} returns the names of an object, after
making them \code{minimal}.
}
