% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-data-frame.R, R/type-tibble.R
\name{df_ptype2}
\alias{df_ptype2}
\alias{df_cast}
\alias{tib_ptype2}
\alias{tib_cast}
\title{Coercion between two data frames}
\usage{
df_ptype2(x, y, ..., x_arg = "", y_arg = "", call = caller_env())

df_cast(x, to, ..., x_arg = "", to_arg = "", call = caller_env())

tib_ptype2(x, y, ..., x_arg = "", y_arg = "", call = caller_env())

tib_cast(x, to, ..., x_arg = "", to_arg = "", call = caller_env())
}
\arguments{
\item{x, y, to}{Subclasses of data frame.}

\item{...}{If you call \code{df_ptype2()} or \code{df_cast()} from a
\code{vec_ptype2()} or \code{vec_cast()} method, you must forward the dots
passed to your method on to \code{df_ptype2()} or \code{df_cast()}.}

\item{x_arg}{Argument names for \code{x} and \code{y}. These are used
in error messages to inform the user about the locations of
incompatible types (see \code{\link[=stop_incompatible_type]{stop_incompatible_type()}}).}

\item{y_arg}{Argument names for \code{x} and \code{y}. These are used
in error messages to inform the user about the locations of
incompatible types (see \code{\link[=stop_incompatible_type]{stop_incompatible_type()}}).}

\item{call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}

\item{to_arg}{Argument names for \code{x} and \code{to}. These are used
in error messages to inform the user about the locations of
incompatible types (see \code{\link[=stop_incompatible_type]{stop_incompatible_type()}}).}
}
\value{
\itemize{
\item When \code{x} and \code{y} are not compatible, an error of class
\code{vctrs_error_incompatible_type} is thrown.
\item When \code{x} and \code{y} are compatible, \code{df_ptype2()} returns the common
type as a bare data frame. \code{tib_ptype2()} returns the common type
as a bare tibble.
}
}
\description{
\code{df_ptype2()} and \code{df_cast()} are the two functions you need to
call from \code{vec_ptype2()} and \code{vec_cast()} methods for data frame
subclasses. See \link[=howto-faq-coercion-data-frame]{?howto-faq-coercion-data-frame}.
Their main job is to determine the common type of two data frames,
adding and coercing columns as needed, or throwing an incompatible
type error when the columns are not compatible.
}
