% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/io_vcfR.R
\name{read.vcfR}
\alias{read.vcfR}
\alias{write.vcf}
\title{Read and write vcf format files}
\usage{
read.vcfR(file, limit = 1e+07, nrows = -1, skip = 0, cols = NULL,
  verbose = TRUE)

write.vcf(x, file = "", mask = FALSE, APPEND = FALSE)
}
\arguments{
\item{file}{A filename for a variant call format (vcf) file.}

\item{limit}{amount of memory (in bytes) not to exceed when reading in a file.}

\item{nrows}{integer specifying the maximum number of rows (variants) to read in.}

\item{skip}{integer specifying the number of rows (variants) to skip before beginning to read data.}

\item{cols}{vector of column numbers to extract from file.}

\item{verbose}{report verbose progress.}

\item{x}{An object of class vcfR or chromR.}

\item{mask}{logical vector indicating rows to use.}

\item{APPEND}{logical indicating whether to append to existing vcf file or write a new file.}
}
\value{
read.vcfR returns an object of class \code{\link{vcfR-class}}.
See the \strong{vignette:} \code{vignette('vcf_data')}
}
\description{
Read and files in the *.vcf structured text format, as well as the compressed *.vcf.gz format.
Write objects of class vcfR to *.vcf.gz.
}
\details{
The function \strong{read.vcfR} reads in files in *.vcf (text) and *.vcf.gz (gzipped text) format and returns an object of class vcfR.
The parameter 'limit' is an attempt to keep the user from trying to read in a file which contains more data than there is memory to hold.
Based on the dimensions of the data matrix, an estimate of how much memory needed is made.
If this estimate exceeds the value of 'limit' an error is thrown and execution stops.
The user may increase this limit to any value, but is encourages to compare that value to the amout of available physical memory.


The function \strong{write.vcf} takes an object of either class vcfR or chromR and writes the vcf data to a vcf.gz file (gzipped text).
If the parameter 'mask' is set to FALSE, the entire object is written to file.
If the parameter 'mask' is set to TRUE and the object is of class chromR (which has a mask slot), this mask is used to subset the data.
If an index is supplied as 'mask', then this index is used, and recycled as necessary, to subset the data.
}
\seealso{
CRAN:
\href{http://cran.r-project.org/package=pegas}{pegas}::read.vcf,
\href{http://cran.r-project.org/package=PopGenome}{PopGenome}::readVCF,
\href{http://cran.r-project.org/package=data.table}{data.table}::fread

Bioconductor:
\href{http://www.bioconductor.org/packages/release/bioc/html/VariantAnnotation.html}{VariantAnnotation}::readVcf

Use: browseVignettes('vcfR') to find examples.
}

