\name{arch}

\alias{arch}

\alias{print.varcheck}

\title{ARCH-LM test}

\encoding{latin1}

\description{
  This function computes univariate and multivariate ARCH-LM tests for a VAR(p). 
}

\usage{
arch(x, lags.single = 16, lags.multi = 5)
}

\arguments{
  \item{x}{Object of class \sQuote{\code{varest}}; generated by
    \code{VAR()}, or an object of class \sQuote{\code{vec2var}}; generated by
    \code{vec2var()}.}
  \item{lags.single}{An integer specifying the lags to be used for the
    univariate ARCH statistics.}
  \item{lags.multi}{An integer specifying the lags to be used for the
    multivariate ARCH statistic.}
  
}
\details{
  The multivariate ARCH-LM test is based on the following regression
  (the univariate test can be considered as special case of the
  exhibtion below and is skipped):

  \deqn{
    vech(\bold{\hat{u}}_t \bold{\hat{u}}_t') = \bold{\beta}_0 + B_1
    vech(\bold{\hat{u}}_{t-1} \bold{\hat{u}}_{t-1}') + \ldots + B_q
    vech(\bold{\hat{u}}_{t-q} \bold{\hat{u}}_{t-q}' + \bold{v}_t)
  }
  whereby \eqn{\bold{v}_t} assigns a spherical error process and
  \eqn{vech} is the column-stacking operator for symmetric matrices
  that stacks the columns from the main diagonal on downwards. The
  dimension of \eqn{\bold{\beta}_0} is \eqn{\frac{1}{2}K(K +1)} and for
  the coefficient matrices \eqn{B_i} with \eqn{i=1, \ldots, q},
  \eqn{\frac{1}{2}K(K +1) \times \frac{1}{2}K(K +1)}. The null
  hypothesis is: \eqn{H_0 := B_1 = B_2 = \ldots = B_q = 0} and the
  alternative is: \eqn{H_1: B_1 \neq 0 or B_2 \neq 0 or \ldots B_q  \neq
    0}.
  The test statistic is:

  \deqn{
    VARCH_{LM}(q) = \frac{1}{2}T K (K + 1)R_m^2 \quad ,
  }
  with
  \deqn{
    R_m^2 = 1 - \frac{2}{K(K+1)}tr(\hat{\Omega} \hat{\Omega}_0^{-1})
    \quad ,
  }
  and \eqn{\hat{\Omega}} assigns the covariance matrix of the above
    defined regression model. This test statistic is distributed as
    \eqn{\chi^2(qK^2(K+1)^2/4)}.      
}
  
\value{
  A list with class attribute \sQuote{\code{varcheck}} holding the
  following elements:\cr

  \item{resid}{A matrix with the residuals of the VAR.}
  \item{arch.uni}{A list with objects of class \sQuote{\code{htest}}
    containing the univariate ARCH-LM tests per equation.}
  \item{arch.mul}{An object with class attribute \sQuote{\code{htest}}
      containing the multivariate ARCH-LM statistic.}
}

\author{Bernhard Pfaff}

\references{
  Doornik, J. A. and D. F. Hendry (1997), \emph{Modelling Dynamic
    Systems Using PcFiml 9.0 for Windows}, International Thomson
  Business Press, London.

  Engle, R. F. (1982), Autoregressive conditional heteroscedasticity
  with estimates of the variance of United Kingdom inflation,
  \emph{Econometrica}, \bold{50}: 987-1007.
  
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Ltkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
  Analysis}, Springer, New York.
}

\seealso{
  \code{\link{VAR}}, \code{\link{vec2var}}, \code{\link{resid}},
  \code{\link{plot}}
}

\examples{
data(Canada)
var.2c <- VAR(Canada, p = 2, type = "const")
arch(var.2c)
}

\keyword{regression}
\concept{VAR}
\concept{VECM}
\concept{Vector autoregressive model}
\concept{ARCH}
\concept{Heteroskedasticity}
\concept{Autoregressive Conditional Heteroskedasticity}


