\name{SVAR2}

\alias{SVAR2}

\title{Estimation of a SVAR (scoring algorithm)}

\encoding{latin1}

\description{
  Estimates an SVAR (either \sQuote{A-model}, \sQuote{B-model} or
  \sQuote{AB-model}) by utilising a scoring algorithm.  
}
  
\usage{
SVAR2(x, Ra = NULL, Rb = NULL, ra = NULL, rb = NULL, start = NULL,
max.iter = 100, conv.crit = 0.1e-6, maxls = 1.0, lrtest = TRUE)
}

\arguments{
  \item{x}{Object of class \sQuote{\code{varest}}; generated by
    \command{VAR()}.}
  \item{Ra}{Matrix of the explicit form constraints on A.}
  \item{Rb}{Matrix of the explicit form constraints on B.}
  \item{ra}{Vector of the non-homogenous part of constraints on A.}  
  \item{rb}{Vector of the non-homogenous part of constraints on B.}  
  \item{start}{Vector of starting values for \eqn{\gamma}.}  
  \item{max.iter}{Integer, maximum number of iteration.}
  \item{conv.crit}{Real, convergence value of algorithm..}
  \item{maxls}{Real, maximum movement of the parameters between two
    iterations of the scoring algorithm.}
  \item{lrtest}{Logical, over-identification LR test, the result is set
    to \command{NULL} for just-identified system.}
}

\details{
  Consider the following structural form of a k-dimensional vector
  autoregressive model: 

  \deqn{
    A \bold{y}_t = A_1^*\bold{y}_{t-1} + \ldots + A_p^*\bold{y}_{t-p} +
    C^*D_t + B\bold{\varepsilon}_t
  }

  The coeffiecient matrices \eqn{(A_1^* | \ldots | A_p^* | C^*)} might
  now differ from the ones of a VAR (see \code{?VAR}). One can now
  impose restrictions on \sQuote{\code{A}} and/or \sQuote{\code{B}},
  resulting in an \sQuote{A-model} or \sQuote{B-model} or if the
  restrictions are placed on both matrices, an \sQuote{AB-model}.
  In contrast to the function \command{SVAR()}, the restrictions have to
  be provided in explicit form:

  \deqn{
    vec(A) = R_a \gamma_a + r_a
  }

  and/or

  \deqn{
    vec(B) = R_b \gamma_b + r_b
  }

  Please note that for either an \sQuote{A-model} or \sQuote{B-model},
  \eqn{K(K-1)/2} restrictions have to be imposed, such that the models'
  coefficients are identified. For an \sQuote{AB-model} the number of
  restrictions amounts to: \eqn{K^2 + K(K-1)/2}. The unknown parameters
  are estimated by a scoring algorithm. The reduced form residuals can
  be obtained from the above equation \emph{via} the relation:
  \eqn{\bold{u}_t = A^{-1}B\bold{\varepsilon}_t}, with
  variance-covariance matrix \eqn{\Sigma_U = A^{-1}BB'A^{-1'}}.\cr      
  
  Finally, in case of an overidentified SVAR, a likelihood ratio
  statistic is computed according to: 

  \deqn{
    LR = T(\ln\det(\tilde{\Sigma}_u^r) - \ln\det(\tilde{\Sigma}_u))
    \quad , 
  }
  
  with \eqn{\tilde{\Sigma}_u^r} being the restricted variance-covariance
  matrix and \eqn{\tilde{\Sigma}_u} being the variance covariance matrix
  of the reduced form residuals. The test statistic is distributed as
  \eqn{\chi^2(nr - 2K^2 - \frac{1}{2}K(K + 1))}, where \eqn{nr} is equal
  to the number of restrictions.  
}

\value{
  A list of class \sQuote{\code{svarest}} with the following elements is
  returned:\cr
  
  \item{A}{If A- or AB-model, the matrix of estimated coeffiecients.}
  \item{Ase}{If \sQuote{\code{hessian = TRUE}}, the standard errors of
    \sQuote{\code{A}}, otherwise a null-matrix is returned.}
  \item{B}{If A- or AB-model, the matrix of estimated coeffiecients.}
  \item{Bse}{If \sQuote{\code{hessian = TRUE}}, the standard errors of
    \sQuote{\code{B}}, otherwise a null-matrix is returned.}
  \item{LRIM}{For Blanchard-Quah estimation \code{LRIM} is the estimated
    long-run impact matrix; for all other SVAR models \code{LRIM} is
    \code{NULL}.}  
  \item{Sigma.U}{The variance-covariance matrix of the reduced form
    residuals times 100, \emph{i.e.}, \eqn{\Sigma_U = A^{-1}BB'A^{-1'}
      \times 100}.}
  \item{LR}{Object of class \sQuote{code{htest}}, holding the Likelihood
  ratio overidentification test.}
  \item{opt}{Is set to \command{NULL} for function \command{SVAR2()}.}
  \item{start}{Vector of starting values.}
  \item{type}{SVAR-type, character, either \sQuote{A-model},
    \sQuote{B-model} or \sQuote{AB-model}.}
  \item{var}{The \sQuote{\code{varest}} object \sQuote{\code{x}}.} 
  \item{call}{The \code{call} to \command{SVAR()}.}
}

\author{Bernhard Pfaff}

\references{
  Amisano, G. and C. Giannini (1997), \emph{Topics in Structural VAR
    Econometrics}, 2nd edition, Springer, Berlin.

  Breitung, J., R. Brggemann and H. Ltkepohl (2004), Structural vector
  autoregressive modeling and impulse responses, in H. Ltkepohl and
  M. Krtzig (editors), \emph{Applied Time Series Econometrics},
  Cambridge University Press, Cambridge.
  
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Ltkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York.
}

\seealso{
  \code{\link{VAR}}, \code{\link{SVAR}}, \code{\link{SVEC}},
  \code{\link{logLik}}, \code{\link{irf}}, \code{\link{fevd}} 
}

\examples{
data(Canada)
varcad <- VAR(Canada, p = 2, type = "const")
Ra <- matrix(0, nrow = 16, ncol = 5)
Ra[1, 1] <- 1
Ra[4, 2] <- 1
Ra[6, 3] <- 1
Ra[11, 4] <- 1
Ra[16, 5] <- 1
ra <- rep(0, 16)
SVAR2(x = varcad, Ra = Ra, Rb = NULL, ra = ra, rb = NULL, lrtest = TRUE,
start = abs(rnorm(5)), max.iter = 100, maxls = 1000, conv.crit = 1.0e-8)
}
\keyword{regression}
\concept{SVAR}
\concept{Structural VAR}
\concept{Structural Vector Autoregressive}
\concept{A-model}
\concept{B-model}
\concept{AB-model}
