\name{plot.varstabil}

\alias{plot.varstabil}

\encoding{latin1}

\title{Plot method for objects of class varstabil}

\description{
  Plots of the empirical fluctuation process of each equation in a VAR(p).
}

\usage{
\method{plot}{varstabil}(x, ...)
}

\arguments{
  \item{x}{An object of class \sQuote{\code{varstabil}}, generated by
    \command{stability()}.}  
  \item{\dots}{Currently not used.}
}

\author{Bernhard Pfaff}

\references{
   Zeileis, A., F. Leisch, K. Hornik and C. Kleiber (2002), strucchange:
   An R Package for Testing for Structural Change in Linear Regression
   Models, \emph{Journal of Statistical Software}, \bold{7(2)}: 1-38,
   \url{http://www.jstatsoft.org/v07/i02/}

   and see the references provided in the reference section of
   \code{\link[strucchange]{efp}}, too.   
}

\seealso{
  \code{\link{stability}}, \code{\link[strucchange]{efp}}  
}

\examples{
\dontrun{
data(Canada)
var.2c <- VAR(Canada, p = 2, type = "const")
var.2c.stabil <- stability(var.2c, type = "Rec-CUSUM")
plot(var.2c.stabil)
}
}

\keyword{regression}
