% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covjmcm_acd.R
\name{covjmcm_acd}
\alias{covjmcm_acd}
\title{Calculate the estimation of the covariance of estimated parameters in a ACD model, via the explicit formula.}
\usage{
covjmcm_acd(object)
}
\arguments{
\item{object}{a fitted joint mean-covariance model of class "jmcmMod", returned by the function \code{jmcm}.}
}
\value{
an estimated covariance matrix of the estimated parameters in a ACD model.
}
\description{
\code{covjmcm_acd} calculates the estimation of the covariance of estimated parameters in a ACD model using
the explicit formula, which is the inverse of the estimated Fisher's information matrix.
}
\examples{
##This may take more than 5s.
\donttest{
cattleA <- cattle[cattle$group=='A', ]
fit.acd <- jmcm(weight|id|I(ceiling(day/14+1))~1|1,
               data = cattleA, cov.method = "acd",
               triple = c(8,3,4))
cov.acd <- covjmcm_acd(fit.acd)}
}
\references{
[1] M. Maadooliat, M. Pourahmadi and J. Z. Huang, "Robust estimation of the correlation
matrix of longitudinal data", Statistics and Computing 23, 17-28, (2013).
}
\seealso{
\code{\link{covjmcm}}, \code{\link{covjmcm_mcd}}, and \code{\link{covjmcm_hpc}}
}
