% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcStruct.R
\name{funcStruct}
\alias{funcStruct}
\alias{modelStructnlme}
\alias{modelStructlme4}
\alias{modelStructsaemix}
\title{Extracting models structures}
\usage{
modelStructnlme(m1, m0, randm0)

modelStructlme4(m1, m0, linmodel, randm0)

modelStructsaemix(m1, m0, randm0)
}
\arguments{
\item{m1}{the model under H1}

\item{m0}{the model under H0}

\item{randm0}{a boolean stating whether the model under H0 contains any random effect}

\item{linmodel}{(only for \code{modelStructlme4}) a boolean to specify whether the model is linear or not}
}
\value{
A list with the following components:
\item{\code{detailStruct}}{a data frame containing 8 variables: \code{name} with the name of the model parameters, \code{var1} and
\code{var2} with the names of the two variances associated with each covariance parameter, \code{type} giving the type of parameter
(\code{beta} for fixed effects, \code{sd} for variances and \code{co} for covariances), \code{tested} equal to \code{TRUE} if the parameter is
tested and \code{FALSE} otherwise, \code{block} giving the block number to which the variance component parameter belongs (equal 0 for
fixed effects), \code{covTested} indicating whether a covariance is tested without the associated variances being tested,
and \code{covInBlock} indicating whether a covariance is tested within a block of the complete covariance matrix}
\item{\code{dims}}{a list with the dimensions of the models (\code{nbFE1} and \code{nbFE0} the number of fixed effects in m1 and m0,
\code{nbRE1} and \code{nbRE0} the number of random effects in m1 and m0 and \code{dimSigma} the number of residual error parameters)}
\item{\code{structGamma}}{the structure of the covariance matrix of the random effects as a list of three logical elements: \code{diag},
\code{full} and \code{blockDiag}, equal to \code{TRUE} if the matrix is diagonal, full or block-diagonal respectively.}
}
\description{
Functions extracting the structure of the models for each package \code{nlme}, \code{lme4}
and \code{saemix}.
}
