% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_shuffle.r
\name{bed_shuffle}
\alias{bed_shuffle}
\title{Shuffle input intervals.}
\usage{
bed_shuffle(
  x,
  genome,
  incl = NULL,
  excl = NULL,
  max_tries = 1000,
  within = FALSE,
  seed = 0
)
}
\arguments{
\item{x}{\link{ivl_df}}

\item{genome}{\link{genome_df}}

\item{incl}{\link{ivl_df} of included intervals}

\item{excl}{\link{ivl_df} of excluded intervals}

\item{max_tries}{maximum tries to identify a bounded interval}

\item{within}{shuffle within chromosomes}

\item{seed}{seed for reproducible intervals}
}
\value{
\link{ivl_df}
}
\description{
Shuffle input intervals.
}
\examples{
genome <- tibble::tribble(
 ~chrom, ~size,
 "chr1", 1e6,
 "chr2", 2e6,
 "chr3", 4e6
)

x <- bed_random(genome, seed = 1010486)

bed_shuffle(x, genome, seed = 9830491)

}
\seealso{
\url{http://bedtools.readthedocs.io/en/latest/content/tools/shuffle.html}

Other randomizing operations: 
\code{\link{bed_random}()}
}
\concept{randomizing operations}
