% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_shuffle.r
\name{bed_shuffle}
\alias{bed_shuffle}
\title{Shuffle input intervals.}
\usage{
bed_shuffle(x, genome, incl = NULL, excl = NULL, max_tries = 1000,
  within = FALSE, seed = 0)
}
\arguments{
\item{x}{\code{\link[=tbl_interval]{tbl_interval()}}}

\item{genome}{\code{\link[=tbl_genome]{tbl_genome()}}}

\item{incl}{\code{\link[=tbl_interval]{tbl_interval()}} of included intervals}

\item{excl}{\code{\link[=tbl_interval]{tbl_interval()}} of excluded intervals}

\item{max_tries}{maximum tries to identify a bounded interval}

\item{within}{shuffle within chromosomes}

\item{seed}{seed for reproducible intervals}
}
\value{
\code{\link[=tbl_interval]{tbl_interval()}}
}
\description{
Shuffle input intervals.
}
\examples{
genome <- trbl_genome(
 ~chrom, ~size,
 "chr1", 1e6,
 "chr2", 2e6,
 "chr3", 4e6
)

x <- bed_random(genome)
bed_shuffle(x, genome)

}
\seealso{
\url{http://bedtools.readthedocs.io/en/latest/content/tools/shuffle.html}

Other randomizing operations: \code{\link{bed_random}}
}
