% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syntax.R
\name{is_unique}
\alias{is_unique}
\alias{all_unique}
\alias{n_unique}
\title{Test for uniquenes of records}
\usage{
is_unique(...)

all_unique(...)

n_unique(...)
}
\arguments{
\item{...}{When used in a validation rule: a bare (unquoted) list of variable names.
When used directly, a comma-separated list of vectors of equal length.}
}
\value{
For \code{is_unique} A logical vector that is \code{FALSE} for each record
  that has a duplicate.

For \code{all_unique} a single \code{TRUE} or \code{FALSE}.

For \code{number_unique} a single number representing the number
        of unique values or value combinations in the arguments.
}
\description{
Test for uniqueness of columns or combinations of columns.
}
\examples{

d <- data.frame(X = c('a','b','c','b'), Y = c('banana','apple','banana','apple'), Z=1:4)
v <- validator(is_unique(X, Y))
values(confront(d, v))

# example with groupwise test
df <- data.frame(x=c(rep("a",3), rep("b",3)),y=c(1,1,2,1:3))
v <- validator(is_unique(y, by=x))
values(confront(d,v))

}
\seealso{
Other cross-record-helpers: 
\code{\link{contains_exactly}()},
\code{\link{do_by}()},
\code{\link{exists_any}()},
\code{\link{hb}()},
\code{\link{hierarchy}()},
\code{\link{is_complete}()},
\code{\link{is_linear_sequence}()}
}
\concept{cross-record-helpers}
