## ------------------------------------------------------------------------
data(women)
summary(women)

## ------------------------------------------------------------------------
library(validate)
cf <- check_that(women, height > 0, weight > 0, height/weight > 0.5)
summary(cf)

## ----eval=FALSE----------------------------------------------------------
#  women %>% check_that(height > 0, weight > 0, height/weight > 0.5) %>% summary()

## ------------------------------------------------------------------------
barplot(cf,main="Checks on the women data set")

## ------------------------------------------------------------------------
v <- validator(height > 0, weight > 0, height/weight > 0)
v

## ------------------------------------------------------------------------
cf <- confront(women,v)
cf

## ------------------------------------------------------------------------
summary(cf)

## ------------------------------------------------------------------------
v <- validator(
  BMI := (weight*0.45359)/(height*0.0254)^2
  , height > 0
  , weight > 0
  , BMI < 23
  , mean(BMI) > 22 & mean(BMI) < 22.5
)
v

## ------------------------------------------------------------------------
cf <- confront(women,v)
summary(cf)

## ------------------------------------------------------------------------
cf <- check_that(women, height>0, weight>0,height/weight < 0.5)
aggregate(cf) 

## ------------------------------------------------------------------------
head(aggregate(cf,by='record'))

## ------------------------------------------------------------------------
# rules with most violations sorting first:
sort(cf)

## ------------------------------------------------------------------------
v <- validator(hite > 0, weight>0)
summary(confront(women, v))

## ----eval=FALSE----------------------------------------------------------
#  # this gives an error
#  confront(women, v, raise='all')

## ------------------------------------------------------------------------
v <- validator(rat = height/weight > 0.5, htest=height>0, wtest=weight > 0)
names(v)

## ------------------------------------------------------------------------
names(v)[1] <- "ratio"
v

## ------------------------------------------------------------------------
summary(v)

## ------------------------------------------------------------------------
variables(v)
variables(v,as="matrix")

## ------------------------------------------------------------------------
v[c(1,3)]
v['ratio','wtest']

## ------------------------------------------------------------------------
v[[1]]

