% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/expressionset.R, R/rule.R
\docType{methods}
\name{created,expressionset-method}
\alias{created}
\alias{created,expressionset-method}
\alias{created,rule-method}
\title{Creation timestamp}
\usage{
\S4method{created}{expressionset}(x, ...)

created(x, ...)

\S4method{created}{rule}(x, ...)
}
\arguments{
\item{x}{and R object}

\item{...}{Arguments to be passed to other methods}
}
\value{
A \code{POSIXct} vector.
}
\description{
Creation timestamp
}
\section{Methods (by class)}{
\itemize{
\item \code{expressionset}: Creation time of every rule in \code{x}
}}
\examples{

# retrieve properties
v <- validator(turnover > 0, staff.costs>0)

# number of rules in v:
length(v)

# per-rule
created(v)
origin(v)
names(v)

# set properties
names(v)[1] <- "p1"

label(v)[1] <- "turnover positive"
description(v)[1] <- "
According to the official definition,
only positive values can be considered
valid turnovers.
"

# short description is also printed:
v

# print all info for first rule
v[[1]]


}
\seealso{
\itemize{
\item{\code{\link{names,expressionset-method}}, \code{\link{length,expressionset-method}}}
\item{\code{\link{description}}, \code{\link{label}}, \code{\link{origin}} \code{\link{variables}}}
}
}

