% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/confrontation.R
\docType{methods}
\name{confront}
\alias{confront}
\alias{confront,data.frame,indicator,ANY-method}
\alias{confront,data.frame,validator,ANY-method}
\alias{confront,data.frame,validator,data.frame-method}
\alias{confront,data.frame,validator,environment-method}
\alias{confront,data.frame,validator,list-method}
\title{Confront data with a (set of) expressionset(s)}
\usage{
confront(dat, x, ref, ...)

\S4method{confront}{data.frame,indicator,ANY}(dat, x, key = NULL, ...)

\S4method{confront}{data.frame,validator,ANY}(dat, x, key = NULL, ...)

\S4method{confront}{data.frame,validator,environment}(dat, x, ref, key = NULL,
  ...)

\S4method{confront}{data.frame,validator,data.frame}(dat, x, ref, key = NULL,
  ...)

\S4method{confront}{data.frame,validator,list}(dat, x, ref, key = NULL, ...)
}
\arguments{
\item{dat}{An R object carrying data}

\item{x}{An R object carrying \code{\link{rule}}s.}

\item{ref}{Optionally, an R object carrying reference data. See examples for usage.}

\item{...}{Options used at execution time (especially \code{'raise'}). See \code{\link{validate_options}}.}

\item{key}{(optional) name of identifying variable in x.}
}
\description{
Confront data with a (set of) expressionset(s)
}
\section{Using reference data}{

When reference data sets are given, it is assumed that rows in the reference data
are ordered corresponding to the rows of \code{dat}, except when a \code{key} is specified.
In that case, all reference datasets are matched against the rows of \code{dat} using \code{key}
Nonmatching records are removed from datasets in \code{ref}. If there are records in \code{dat}
that are not in \code{ref}, then datasets in \code{ref} are extended with records containing only \code{NA}.
In particular, this means that wen reference data is passed in an environment, those reference data sets
may altered by the call to \code{confront}.

Technically, reference data will be stored in an environment that is the parent of a (created) environment that
contains the columns of \code{dat}.
}
\examples{

# An example using reference data
v <- validator(weight == ref$weight)
summary(confront(women, v, women))

# Usging custom names for reference data
v <- validator(weight == test$weight)
summary( confront(women,v, list(test=women)) )

# Reference data in an environment
e <- new.env()
e$test <- women
v <- validator(weight == test$weight)
summary( confront(women, v, e) )

# the effect of using a key
w <- women
w$id <- letters[1:nrow(w)]
v <- validator(weight == ref$weight)

# with complete data; already matching
values( confront(w, v, w, key='id'))

# with scrambled rows in reference data (reference gets sorted according to dat)
i <- sample(nrow(w))
values(confront(w, v, w[i,],key='id'))

# with incomplete reference data
values(confront(w, v, w[1:10,],key='id'))


}
\seealso{
\itemize{
 \item{\code{\link{validate_options}}}
 \item{\code{\link{summary,validation-method}}, \code{\link{aggregate,validation-method}}, \code{\link{sort,validation-method}}}
 \item{\code{\link{summary,indication-method}}}
 \item{\code{\link{indicator}}, \code{\link{indicator-class}}}
 \item{\code{\link{validator}}, \code{\link{validator-class}}}
}
}

