% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{utiml_iterative_split}
\alias{utiml_iterative_split}
\title{Internal Iterative Stratification}
\usage{
utiml_iterative_split(mdata, r)
}
\arguments{
\item{mdata}{A mldr dataset.}

\item{r}{Desired proportion of examples in each subset r1, . . . rk.}
}
\value{
A list with k disjoint indexes subsets S1, . . .Sk.
}
\description{
Create the indexes using the Iterative Stratification algorithm.
}
\examples{
\dontrun{
# Create 3 partitions for train, validation and test
indexes <- utiml_iterative_split(emotions, c(0.6,0.1,0.3))

# Create a stratified 10-fold
indexes <- utiml_iterative_split(emotions, rep(0.1,10))
}
}
\references{
Sechidis, K., Tsoumakas, G., & Vlahavas, I. (2011). On the
 stratification of multi-label data. In Proceedings of the Machine
 Learningand Knowledge Discovery in Databases - European Conference,
 ECML PKDD (pp. 145-158).
}

