% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulate.R
\name{tabulate_model.coxph}
\alias{tabulate_model.coxph}
\title{Tabulate Model: Cox PH}
\usage{
\method{tabulate_model}{coxph}(fit, format = TRUE, percent.sign = TRUE,
  digits = 1, p.digits = 4)
}
\arguments{
\item{fit}{Required. survival::coxph() object.}

\item{format}{Optional. Logical. Rounds numbers and formats text for a
cleaner, readable output. Defaults to TRUE.}

\item{percent.sign}{Optional. Logical. Indicates percent sign should be printed
for frequencies. Defaults to TRUE.}

\item{digits}{Optional. Integer. Number of digits to round to. Defaults to 1.}

\item{p.digits}{Optional. Integer. Number of p-value digits to print. Note that
p-values are still rounded using 'digits'. Defaults to 4.}
}
\description{
Converts parameters from a cox parametric hazards model
into a usable table for publication purposes.
}
\examples{
library(tibble)
library(survival)

# coxph() Object
coxph_data <- as_tibble(cgd)

tabulate_model(
   fit = coxph(
      Surv(tstart, tstop, status) ~ age + center + sex,
      data = coxph_data
   )
 )
}
\seealso{
\code{\link{tabulate_model}}
}
