% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_model_output.R
\name{get_params}
\alias{get_params}
\title{Extract fitted parameters}
\usage{
get_params(fit, initial_params, free_param_index, param_names,
  inv_param_transform_fn, index = NULL)
}
\arguments{
\item{fit}{the output of optim i.e. the fitted model for a particular subject}

\item{initial_params}{named vector of the initial parameter guess}

\item{free_param_index}{logical TRUE/FALSE vector indicating whether the parameters A, delta, B, gamma are to be recovered. This should be c(TRUE, TRUE, TRUE, TRUE) for the biphasic model and c(FALSE, FALSE, TRUE, TRUE) for the single phase model.}

\item{param_names}{character vector of the parameter names. This should be c("A", "delta", "B", "gamma") for the biphasic model or c("B", "gamma") for the single phase model.}

\item{inv_param_transform_fn}{list of transformation functions to be used when back-transforming the transformed parameters. Should be the inverse of the forward transformation functions.}

\item{index}{indicator value used inside the master function to indicate the subject number.}
}
\description{
This function extracts all untransformed parameters from the output of optim (i.e. the fitted model).
}
