\name{examine}
\alias{examine}
\alias{examineBy}
\title{
Examine one or more variables
}
\description{
These functions are one of many R functions enabling users to assess variable descriptives. They have been developed to mimic SPSS' 'EXAMINE' syntax command ('Explore' in the menu) as closely as possible to ease the transition for new R users and facilitate teaching courses where both programs are taught alongside each other.
}
\usage{
examine(..., stem = TRUE, plots = TRUE,
        extremeValues = 5, descr.include = NULL,
        qqCI = TRUE, conf.level = 0.95)
examineBy(..., by=NULL, stem = TRUE, plots = TRUE,
          extremeValues = 5, descr.include=NULL,
          qqCI = TRUE, conf.level=.95)
}
\arguments{
  \item{\dots}{
The first argument is a list of variables to provide descriptives for. Because these are the first arguments, the other arguments must be named explicitly so R does not confuse them for something that should be part of the dots.
}
  \item{by}{
  A variable by which to split the dataset before calling \code{\link{examine}}. This can be used to show the descriptives separate by levels of a factor.
  }
  \item{stem}{
Whether to display a stem and leaf plot.
}
  \item{plots}{
Whether to display the plots generated by the \code{\link{dataShape}} function.
}
  \item{extremeValues}{
How many extreme values to show at either end (the highest and lowest values). When set to FALSE (or 0), no extreme values are shown.
}
  \item{qqCI}{
Whether to display confidence intervals in the QQ-plot.
}
  \item{descr.include}{
  Which descriptives to include; see \code{\link{descr}} for more information.
  }
  \item{conf.level}{
  The level of confidence of the confidence interval.
  }
}
\details{
This function basically just calls the \code{\link{descr}} function, optionally supplemented with calls to \code{\link{stem}}, \code{\link{dataShape}}.
}
\value{
A list that is displayed when printed.
}
\author{
Gjalt-Jorn Peters

Maintainer: Gjalt-Jorn Peters <gjalt-jorn@userfriendlyscience.com>
}

\seealso{
\code{\link{descr}}, \code{\link{dataShape}}, \code{\link{stem}}
}
\examples{
### Look at the miles per gallon descriptives:
examine(mtcars$mpg, stem=FALSE, plots=FALSE);

### Separate for the different number of cylinders:
examineBy(mtcars$mpg, by=mtcars$cyl,
          stem=FALSE, plots=FALSE,
          extremeValues=FALSE,
          descr.include=c('central tendency', 'spread'));

}
\keyword{ univar }
