% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hartigan.r
\name{PlotHartigan}
\alias{PlotHartigan}
\title{Plot a series of Hartigan's Numbers}
\usage{
PlotHartigan(hartigan, title = "Hartigan's Rule", smooth = FALSE,
  linecolor = "grey", linetype = 2L, linesize = 1L, minor = TRUE)
}
\arguments{
\item{hartigan}{The results from
\code{\link{FitKMeans}}}

\item{title}{Title to be used in the plot}

\item{smooth}{logical; if true a smoothed line will be fit to the points, otherwise it will be a piecewise line}

\item{linecolor}{Color of the horizontal line denoting 10}

\item{linetype}{Type of the horizontal line denoting 10}

\item{linesize}{Size of the horizontal line denoting 10}

\item{minor}{logical; if true minor grid
lines will be plotted}
}
\value{
a ggplot object
}
\description{
After fitting a series of Hartigan's Numbers (see \code{\link{FitKMeans}}) this will plot the results so it is easy to visualize
}
\details{
Displays a graphical representation of the results of \code{\link{FitKMeans}}
}
\examples{

data(iris)
hartiganResults <- FitKMeans(iris[, -ncol(iris)])
PlotHartigan(hartiganResults)

}
\references{
#' http://www.stat.columbia.edu/~madigan/DM08/descriptive.ppt.pdf
}
\seealso{
\code{\link{kmeans}} \code{\link{FitKMeans}}
}
\author{
Jared P. Lander
www.jaredlander.com
}
\keyword{cluster}
\keyword{clustering}
\keyword{hartigan}
\keyword{kmeans}
