% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updog.R
\docType{package}
\name{updog-package}
\alias{updog-package}
\alias{updog}
\title{\code{updog} Flexible Genotyping for Polyploids}
\description{
Implements empirical Bayes approaches to genotype
polyploids from next generation sequencing data while
accounting for allelic bias, overdispersion, and sequencing
error. The main function is \code{\link{flexdog}}, which allows
the specification of many different genotype distributions.
An experimental function that takes into account varying
levels of relatedness is implemented in \code{\link{mupdog}}.
Also provided are functions to simulate genotypes
(\code{\link{rgeno}}) and read-counts
(\code{\link{rflexdog}}), as well as functions to calculate
oracle genotyping error rates (\code{\link{oracle_mis}}) and
correlation with the true genotypes (\code{\link{oracle_cor}}).
These latter two functions are useful for read depth calculations.
Run \code{browseVignettes(package = "updog")} in R
for example usage. The methods are described in detail in
Gerard et. al. (2018) and Gerard and Ferrão (2019).
}
\details{
The package is named \code{updog} for "Using
Parental Data for Offspring Genotyping" because
we originally developed the
method for full-sib populations, but it works
now for more general populations.

Our best competitor is probably the \code{fitPoly} package,
which you can check out at
\url{https://cran.r-project.org/package=fitPoly}. Though, we think
that \code{updog} returns better calibrated measures of uncertainty
when you have next-generation sequencing data.

If you find a bug or want an enhancement, please submit an
issue at \url{http://github.com/dcgerard/updog/issues}.
}
\section{\code{updog} Functions}{

\describe{
  \item{\code{\link{flexdog}}}{The main function that
      fits an empirical Bayes approach to genotype polyploids
      from next generation sequencing data.}
  \item{\code{\link{multidog}}}{A convenience function for running
      \code{\link{flexdog}} over many SNPs. This function provides
      support for parallel computing.}
  \item{\code{\link{mupdog}}}{An experimental approach to genotype
      autopolyploids that accounts for varying levels of
      relatedness between the individuals in the sample.}
  \item{\code{\link{rgeno}}}{simulate the genotypes of a sample
      from one of the models allowed in \code{\link{flexdog}}.}
  \item{\code{\link{rflexdog}}}{Simulate read-counts from the
      \code{\link{flexdog}} model.}
  \item{\code{\link{plot.flexdog}}}{Plotting the output of
      \code{\link{flexdog}}.}
  \item{\code{\link{plot.mupdog}}}{Plotting the output of
      \code{\link{mupdog}}.}
  \item{\code{\link{oracle_joint}}}{The joint distribution of the true genotype
      and an oracle estimator.}
  \item{\code{\link{oracle_plot}}}{Visualize the output of \code{\link{oracle_joint}}.}
  \item{\code{\link{oracle_mis}}}{The oracle misclassification error rate (Bayes rate).}
  \item{\code{\link{oracle_cor}}}{Correlation between the true genotype and the oracle estimated genotype.}
}
}

\section{\code{updog} Datasets}{

\describe{
  \item{\code{\link{snpdat}}}{A small example dataset for using
      \code{\link{flexdog}}.}
  \item{\code{\link{uitdewilligen}}}{A small example dataset
      for using \code{\link{mupdog}}.}
  \item{\code{\link{mupout}}}{The output from fitting
      \code{\link{mupdog}} to \code{\link{uitdewilligen}}.}
}
}

\references{
\itemize{
  \item{Gerard, D., Ferrão, L. F. V., Garcia, A. A. F., & Stephens, M. (2018). Genotyping Polyploids from Messy Sequencing Data. \emph{Genetics}, 210(3), 789-807. doi: \href{https://doi.org/10.1534/genetics.118.301468}{10.1534/genetics.118.301468}.}
  \item{Gerard, D. and Ferrão, L. F. V. (2019). Priors for Genotyping Polyploids. \emph{Bioinformatics}. doi: \href{https://doi.org/10.1093/bioinformatics/btz852}{10.1093/bioinformatics/btz852}.}
}
}
\author{
David Gerard
}
