% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{compute_all_log_bb}
\alias{compute_all_log_bb}
\title{Calculates the log-density for every individual by snp by dosage level.}
\usage{
compute_all_log_bb(refmat, sizemat, ploidy, seq, bias, od)
}
\arguments{
\item{refmat}{A matrix of reference counts.
The rows index the individuals and the columns index the SNPs.}

\item{sizemat}{A matrix of total counts.
The rows index the individuals and the columns index the SNPs.
Should have the same dimensions as \code{refmat}.}

\item{ploidy}{The ploidy of the species. To estimate the ploidy,
re-run \code{mupdog} at various ploidy levels and choose the one with
the largest ELBO. This assumes that the ploidy is the same for
all individuals in the sample.}

\item{seq}{A vector of initial sequencing errors. Should be
the same length as the number of columns of \code{refmat}
(number of SNPs). Must be between 0 and 1.}

\item{bias}{A vector of initial bias parameters. Should be the
same length as the number of columns of \code{refmat}
(number of SNPs). Must be greater than 0.}

\item{od}{A vector of initial overdispersion parameters.
Should be the same length as the number of columns of
\code{refmat} (number of SNPs). Must be between 0 and 1.}
}
\value{
A three dimensional array. The rows index the individuals, the
    columns index the SNPs, and the third dimension indexes the
    genotypes. This is the log-likelihood for each individual/snp/genotype
    combination.
}
\description{
Calculates the log-density for every individual by snp by dosage level.
}
