% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extend.R
\name{extend}
\alias{extend}
\alias{extend_N}
\alias{extend_E}
\alias{extend_S}
\alias{extend_W}
\title{Extend a bag of cells in one direction, optionally up to a boundary
condition.}
\usage{
extend(bag, cells, direction, n = NULL, boundary = NULL, edge = FALSE,
  include = FALSE)

extend_N(bag, cells, n = NULL, boundary = NULL, edge = FALSE,
  include = FALSE)

extend_E(bag, cells, n = NULL, boundary = NULL, edge = FALSE,
  include = FALSE)

extend_S(bag, cells, n = NULL, boundary = NULL, edge = FALSE,
  include = FALSE)

extend_W(bag, cells, n = NULL, boundary = NULL, edge = FALSE,
  include = FALSE)
}
\arguments{
\item{bag}{Data frame. The original selection, including at least the columns
'row' and 'column', which are numeric/integer vectors.}

\item{cells}{Data frame. All the cells in the sheet, among which to extend
the bag (extensions beyond existing cells will be padded with blank cells).
Must include at least the columns 'row' and 'column', as well as any columns
referred to by the boundary formula.}

\item{direction}{Character vector length 1. The direction in which to extend,
among the compass directions "N", "E", "S", "W", where "N" is north (up).}

\item{n}{Integer vector length 1, >= 0. The number of rows/cols to extend by
in the given direction.}

\item{boundary}{Formula to express a boundary condition.  `~ col <= 50` would
go up to the 50th column.  NAs are treated the same as FALSE, but with a
warning.}

\item{edge}{Logical vector length 1. Whether to require the boundary formula
to be TRUE along the entire leading edge of the bag that is being extended.}

\item{include}{Logical vector length 1. Whether to include in the extension
the first cell (and its row/col of fellow cells) at which the boundary
condition is met.}
}
\description{
A bag of data cells is a data frame with at least the
columns 'row' and 'col', as well as any others that carry information about
the cells, e.g. their values.  More cells may be added to the bag by
extending the bag in a given direction, either by a number of rows or
columns, or up to (and optionally including) cells that meet a boundary
condition.  The boundary may be required to be detected in every cell along
the 'leading edge' of the bag, otherwise extension will stop at the nearest
boundary that is detected.
}
\details{
A bag may have ragged rows or ragged cols. Gaps will be filled in,
even when n = 0.
}
\section{Functions}{
\itemize{
\item \code{extend_N}: Extend a bag of cells to the north

\item \code{extend_E}: Extend a bag of cells to the east

\item \code{extend_S}: Extend a bag of cells to the south

\item \code{extend_W}: Extend a bag of cells to the west
}}

\examples{
# Load some pivoted data
(x <- purpose$`NNW WNW`)
# Make a tidy representation
cells <- tidytable(x, rownames = FALSE, colnames = FALSE)
cells <- cells[!is.na(cells$character), ] # Introduce 'holes' in the data
# Select a particular cell
cell <- cells[which(cells$row == 3 & cells$col == 3), ]
# Extend the selection downwards, stopping before the NA.
extend_S(cell, cells, boundary = ~ is.na(character))
# Extend the selection right, up to and including the fifth column.
extend_E(cell, cells, boundary = ~ col == 5, include = TRUE)
# Extend the selection beyond the existing cells
extend_E(cell, cells, 15)
# This doesn't work inside formulas, because it would mean testing the
# boundary formula on every possible cell in the given direction
\dontrun{extend_E(cell, cells, boundary = ~ col == 15)}
cell <- cells[which(cells$row == 7 & cells$col \%in\% 1:2), ]
extend_N(cell, cells, boundary = ~ !is.na(character), edge = TRUE)
}
