% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{MaximumLikelihoodDistribution}
\alias{MaximumLikelihoodDistribution}
\alias{dml}
\alias{pml}
\alias{qml}
\alias{rml}
\title{Maximum likelihood estimated distribution}
\usage{
dml(x, obj, log = FALSE)

pml(q = q, obj, lower.tail = TRUE, log.p = FALSE)

qml(p = p, obj, lower.tail = TRUE, log.p = FALSE)

rml(n = n, obj)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{obj}{an \code{univariateML} object.}

\item{log, log.p}{logical; if \code{TRUE}, the probabilities p are gives as
\code{log(p)}.}

\item{lower.tail}{logical; if \code{TRUE} (default), the probabilities are
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is
taken to be the number required.}
}
\value{
\code{dml} gives the density, \code{pml} gives the distribution
function, \code{qml} gives the quantile function, and \code{rml}
generates random deviates.
}
\description{
Density, distribution function, quantile function and random generation for
a univariate distribution estimated by maximum likelihood.
}
\details{
\code{dml} is the density, \code{pml} is the distribution function,
\code{qml} is the quantile function, and \code{rml} is the random variable
generator.

These functions work like their counterparts in \code{stats}, e.g.
\link[stats:Normal]{Normal}. The \code{univariateML} object contains both maximum
likelihood estimates and the identity of the model these estimates were
calculated under. These functions are wrappers around underlying density,
distribution, quantile and random generation functions where unknown
parameters are filled with the maximum likelihood estimates.
See the example.
}
\examples{
## Simple example
obj <- mlnorm(airquality$Wind)
dml(0.5, obj) == dnorm(0.5, mean = obj[1], sd = obj[2])

obj <- mlbetapr(airquality$Wind)

# Plot the logarithm of the beta prime distribution.
plot(function(x) dml(x, obj, log = TRUE),
  from = 0, to = 20,
  main = "Logarithm of Density", ylab = NA, lwd = 2
)

}
