% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pals.R
\docType{data}
\name{rptu_pal}
\alias{rptu_pal}
\title{Color palette of the RPTU Kaiserslautern-Landau}
\format{
An object of class \code{character} of length 12.
}
\source{
Color definitions are based on 
\url{https://www.startklar2023.de/brand-portal-rptu}.
}
\usage{
rptu_pal
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{rptu_pal} provides the 12 colors (arranged in 6 pairs) 
of the \href{https://rptu.de/}{RPTU} Kaiserslautern-Landau, Germany.
}
\details{
The acronym "RPTU" denotes "Rheinland-Pfälzische Technische Universität", 
which is co-located in Kaiserslautern and Landau, Germany (since 2023). 

The two colors of a pair may be combined with each other. 
When using only one color pair, shades of 10% may be used in color gradients. 
See examples and the \code{\link{ac}} and \code{\link{usecol}} functions for creating color gradients.
}
\examples{
rptu_pal
seecol(rptu_pal, main = "The colors of RPTU")  # view color palette
demopal(rptu_pal, type = 1, main = "Using the colors of RPTU")

# Gradients:
rptu_10 <- usecol(c(rptu_pal[9], "white"), n = 11)[1:10]
seecol(rptu_10, main = "10 shades of a RPTU color")

rptu_21 <- usecol(c(rptu_pal[1], "white", rptu_pal[2]), n = 21)
seecol(rptu_21, main = "A gradient between a RPTU color pair")

}
\seealso{
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other contributed color palettes: 
\code{\link{caltech_pal_1}},
\code{\link{caltech_pal_2}},
\code{\link{caltech_pal_3}},
\code{\link{eth_pal_1}},
\code{\link{eth_pal_2}},
\code{\link{eth_pal_3}},
\code{\link{fu_pal_0}},
\code{\link{fu_pal_1}},
\code{\link{fu_pal_2}},
\code{\link{fu_pal_3}},
\code{\link{hu_pal_1}},
\code{\link{hu_pal_2}},
\code{\link{lmu_pal_1}},
\code{\link{lmu_pal_2}},
\code{\link{lmu_pal_3}},
\code{\link{mpg_pal}},
\code{\link{rpi_pal_1}},
\code{\link{rpi_pal_2}},
\code{\link{rpi_pal_3}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_princeton_0}},
\code{\link{uni_princeton_1}},
\code{\link{uni_princeton_2}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unikn}, 2023-01-01.
}
\concept{contributed color palettes}
\keyword{datasets}
