% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dundee.R
\docType{data}
\name{dundee_highlight}
\alias{dundee_highlight}
\title{Highlight colours of University of Dundee, Scotland}
\format{
An object of class \code{character} of length 3.
}
\source{
Colour definitions are based on \href{https://www.dundee.ac.uk}{Dundee}'s 
\href{https://www.app.dundee.ac.uk/pattern-library/}{Brand colour palette}.
}
\usage{
dundee_highlight
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{dundee_highlight} provides the highlight colours 
of \href{https://www.dundee.ac.uk}{University of Dundee}, Scotland, UK.
}
\details{
The highlight colours are 
\code{"highlight_1"} (defined as PANTONE 710C, CMYK 0/85/52/0, RGB 255/98/100, HEX #ff6264),
\code{"highlight_2"} (defined as PANTONE 7480C, CMYK 82/0/72/0, RGB 1/209/124, HEX #01d17c) and
\code{"highlight_3"} (defined as 88\% Black, CMYK 0/0/0/88, RGB 70/70/70, HEX #464646).

\code{dundee_highlight} uses the HEX colour definition. 
Pantone and CMYK colours differ from RGB and HEX definition.


Three complementary highlight colours have been specified to add vibrancy to the identity. 
These colours can only be used for typography, icons or delicate line work.
}
\examples{
dundee_highlight
unikn::seecol(dundee_highlight, main = "Highlight colours of Dundee") # view palette

}
\seealso{
\code{\link{dundee_core}} for the core colour of University of Dundee;
\code{\link{dundee_block}} for the block colours of University of Dundee;
\code{\link{dundee_background}} for the background colour of University of Dundee;
\code{\link{seecol}} for viewing and comparing colour palettes;
\code{\link{usecol}} for using colour palettes;
\code{\link{simcol}} for finding similar colours;
\code{\link{newpal}} for defining new colour palettes;
\code{\link{grepal}} for finding named colours.

Other Scottish university color palettes: 
\code{\link{dundee_background}},
\code{\link{dundee_block}},
\code{\link{dundee_core}},
\code{\link{edinburgh}},
\code{\link{standrews_1}},
\code{\link{standrews_2}},
\code{\link{stirling_1}},
\code{\link{stirling_2}},
\code{\link{stirling_3}}
}
\author{
\strong{unicol}, 2023-06-22.
}
\concept{Scottish university color palettes}
\keyword{datasets}
