% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{prolific_anonymize}
\alias{prolific_anonymize}
\title{Clean up a prolific file for sharing by removing anonymity-compromising columns.}
\usage{
prolific_anonymize(
  df = NULL,
  PID = "PID",
  extraColumns = NA,
  baseOffset = 10000
)
}
\arguments{
\item{df}{Existing datafile to anonymize.}

\item{PID}{The prolific ID col name to anonymize}

\item{extraColumns}{Any  extra columns to delete (default NA)}

\item{baseOffset}{The numeric to start renumbering PIDs from (default = 1e4)}
}
\value{
\itemize{
\item [\link{data.frame}]
}
}
\description{
prolific.ac IDs and other columns like IP and lat/long might compromise
subject anonymity when shared.
\code{prolific_anonymize} replaces PIDs with a simple numeric sequence, preserving
repeated measures in long data, and removing other columns.
You can delete additional  columns by adding them to \code{extraColumns}. It is ideal for use
when sharing data to \url{https://researchbox.org} which enforces anonymization.
}
\examples{
\dontrun{
tmp = prolific_anonymize(df, PID = "PID")
}
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link[=prolific_check_ID]{prolific_check_ID()}}, \code{\link[=prolific_read_demog]{prolific_read_demog()}}, \code{\link[=umx_merge_randomized_columns]{umx_merge_randomized_columns()}}
}

Other Data Functions: 
\code{\link{noNAs}()},
\code{\link{prolific_check_ID}()},
\code{\link{prolific_read_demog}()},
\code{\link{umx}},
\code{\link{umxFactor}()},
\code{\link{umxHetCor}()},
\code{\link{umx_as_numeric}()},
\code{\link{umx_cont_2_quantiles}()},
\code{\link{umx_lower2full}()},
\code{\link{umx_make_MR_data}()},
\code{\link{umx_make_TwinData}()},
\code{\link{umx_make_fake_data}()},
\code{\link{umx_make_raw_from_cov}()},
\code{\link{umx_merge_randomized_columns}()},
\code{\link{umx_polychoric}()},
\code{\link{umx_polypairwise}()},
\code{\link{umx_polytriowise}()},
\code{\link{umx_read_lower}()},
\code{\link{umx_rename}()},
\code{\link{umx_reorder}()},
\code{\link{umx_score_scale}()},
\code{\link{umx_select_valid}()},
\code{\link{umx_stack}()},
\code{\link{umx_strings2numeric}()}
}
\concept{Data Functions}
