% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.r
\name{umxSetParameters}
\alias{umxSetParameters}
\title{umxSetParameters: Set parameters in an mxModel}
\usage{
umxSetParameters(model, labels, free = NULL, values = NULL,
  newlabels = NULL, lbound = NULL, ubound = NULL, indep = FALSE,
  strict = TRUE, name = NULL, regex = FALSE, test = FALSE)
}
\arguments{
\item{model}{an \code{\link{mxModel}} to WITH}

\item{labels}{= labels to find}

\item{free}{= new value for free}

\item{values}{= new values}

\item{newlabels}{= newlabels}

\item{lbound}{= value for lbound}

\item{ubound}{= value for ubound}

\item{indep}{= whether to look in indep models}

\item{strict}{whether to complain if labels not found}

\item{name}{= new name for the returned model}

\item{regex}{Is labels a regular expression (defaults to FALSE)}

\item{test}{just show what you would do? (defaults to FALSE)}
}
\value{
- \code{\link{mxModel}}
}
\description{
Free or fix parameters in an \code{\link{mxModel}}.
This allows similar actions that \code{\link{update}} enables
for lm models.
Updating can create duplicate labels, so this function also calls \code{\link{omxAssignFirstParameters}}
to equate the start values for parameters which now have identical labels.
}
\details{
It also supports regular expressions to select labels. In this respect,
it is similar to \code{\link{umxModify}} without running the model.
}
\examples{
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- umxRAM("One Factor", data = mxData(demoOneFactor[1:80,], type = "raw"),
	umxPath(from = latents, to = manifests),
	umxPath(v.m. = manifests),
	umxPath(v1m0 = latents)
)
parameters(m1)
umxSetParameters(m1, regex = "^", newlabels= "m1_", test = TRUE)
m2 = umxSetParameters(m1, "G_to_x1", newlabels= "G_to_x2", test = FALSE)
parameters(m2)
}
\references{
- \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
\seealso{
- \code{\link{umxModify}}, \code{\link{umxLabel}}

Other Modify or Compare Models: \code{\link{umxAdd1}},
  \code{\link{umxDrop1}}, \code{\link{umxEquate}},
  \code{\link{umxFixAll}}, \code{\link{umxMI}},
  \code{\link{umxModify}},
  \code{\link{umxUnexplainedCausalNexus}},
  \code{\link{umx}}
}
\concept{Modify or Compare Models}
