% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umx_build_umxSimplex.R
\name{umxPlotSimplex}
\alias{umxPlotSimplex}
\alias{plot.MxModelSimplex}
\title{Draw and display a graphical figure of a simplex model}
\usage{
umxPlotSimplex(x = NA, file = "name", digits = 2, means = FALSE,
  std = TRUE, format = c("current", "graphviz", "DiagrammeR"),
  strip_zero = TRUE, ...)
}
\arguments{
\item{x}{The \code{\link{umxSimplex}} model to display graphically}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{digits}{How many decimals to include in path loadings (defaults to 2)}

\item{means}{Whether to show means paths (defaults to FALSE)}

\item{std}{Whether to standardize the model (defaults to TRUE)}

\item{format}{= c("current", "graphviz", "DiagrammeR")}

\item{strip_zero}{Whether to strip the leading "0" and decimal point from parameter estimates (default = TRUE)}

\item{...}{Optional additional parameters}
}
\value{
- Optionally return the dot code
}
\description{
Options include digits (rounding), showing means or not, and which output format is desired.
}
\examples{
\dontrun{
# TODO Add example from umxSimplex help
data(iqdat)
mzData = subset(iqdat, zygosity == "MZ")
dzData = subset(iqdat, zygosity == "DZ")
selDVs = c("IQ_age1", "IQ_age2", "IQ_age3", "IQ_age4")
m1 = umxSimplex(selDVs = selDVs, sep = "_T", dzData = dzData, mzData = mzData)
# plot(m1)
}
}
\seealso{
- \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, SAT, simplex, ACEv, or ACE model.

- \code{\link{umxSimplex}}

Other Plotting functions: \code{\link{plot.MxLISRELModel}},
  \code{\link{plot.MxModel}}, \code{\link{umxPlotACEcov}},
  \code{\link{umxPlotACEv}}, \code{\link{umxPlotACE}},
  \code{\link{umxPlotCPold}}, \code{\link{umxPlotCP}},
  \code{\link{umxPlotGxEbiv}}, \code{\link{umxPlotGxE}},
  \code{\link{umxPlotIP}}, \code{\link{umxPlotSexLim}},
  \code{\link{umx}}
}
\concept{Plotting functions}
