% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.R
\name{umxLatent}
\alias{umxLatent}
\title{umxLatent: Helper to ease making formative and reflective latent variables}
\usage{
umxLatent(latent = NULL, formedBy = NULL, forms = NULL,
  data = NULL, type = NULL, fixManifestVariances = FALSE,
  name = NULL, labelSuffix = "", verbose = TRUE)
}
\arguments{
\item{latent}{the name of the latent variable (string)}

\item{formedBy}{the list of manifest variables which latent reflects.}

\item{forms}{the list of variables which this latent forms (leave blank if using formedBy)}

\item{data}{the dataframe being used in this model}

\item{type}{of the latent variable: "exogenous" or "endogenous"}

\item{fixManifestVariances}{defaults to FALSE. Allows a model consisting of just a reflective latent to be identified.}

\item{name}{A name for the path NULL}

\item{labelSuffix}{a suffix string to append to each label}

\item{verbose}{Default is TRUE as this function does quite a lot}
}
\value{
- path list
}
\description{
Helper to ease the creation of latent variables including formative and reflective variables (see below)
For formative variables, the manifests define (form) the latent.
This function takes care of intercorrelating manifests for formatives, and fixing variances correctly
}
\details{
The following figures show how a reflective and a formative variable look as path diagrams:

Note, a reflective latent on its own is not identified as a complete model.
Fixing manifest variances at their observed values can allow this case.

Reflective (manifests reflect the value of the latent variable)

\if{html}{\figure{reflective.png}{options: width="50\%" alt="Figure: reflective.png"}}
\if{latex}{\figure{reflective.pdf}{options: width=7cm}}

Formative (manifests provide the value of the latent variable)

\if{html}{\figure{formative.png}{options: width="50\%" alt="Figure: formative.png"}}
\if{latex}{\figure{formative.pdf}{options: width=7cm}}
}
\examples{
library(umx)
data(demoOneFactor)
latents = c("G")
manifests = names(demoOneFactor) # x1-5
theData = cov(demoOneFactor)
df = mxData(theData, type = "cov", numObs = nrow(demoOneFactor))
m1 = umxRAM("reflective", data = df,
	umxLatent("G", forms = manifests, type = "exogenous", data = theData)
)
umxSummary(m1, show="std")
plot(m1, std = TRUE)

\dontrun{
# I don't recommend using umxLatent at present: It's not a direction I am moving umx in
m2 = umxRAM("formative", data = df,
umxLatent("G", formedBy = manifests, data = df, fixManifestVariances=TRUE)
)
umxSummary(m2, show = "std")
plot(m2, std = TRUE)
}
}
\references{
- \url{https://www.github.com/tbates/umx}
}
\seealso{
Other Advanced Model Building Functions: \code{\link{umxJiggle}},
  \code{\link{umxLabel}}, \code{\link{umxRAM2Ordinal}},
  \code{\link{umxThresholdMatrix}},
  \code{\link{umxValues}},
  \code{\link{umx_fix_first_loadings}},
  \code{\link{umx_fix_latents}},
  \code{\link{umx_get_bracket_addresses}},
  \code{\link{umx_string_to_algebra}}, \code{\link{umx}}
}
\concept{Advanced Model Building Functions}
