% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxSummaryACEcov}
\alias{umxSummary.MxModel.ACEcov}
\alias{umxSummaryACEcov}
\title{umxSummaryACEcov}
\usage{
umxSummaryACEcov(model, digits = 2, file = getOption("umx_auto_plot"),
  returnStd = FALSE, extended = FALSE, showRg = FALSE, std = TRUE,
  comparison = NULL, CIs = TRUE, zero.print = ".", report = c("1", "2",
  "html"), ...)
}
\arguments{
\item{model}{a \code{\link{umxACEcov}} model to summarize}

\item{digits}{round to how many digits (default = 2)}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{returnStd}{Whether to return the standardized form of the model (default = FALSE)}

\item{extended}{how much to report (FALSE)}

\item{showRg}{= whether to show the genetic correlations (FALSE)}

\item{std}{= whether to show the standardized model (TRUE)}

\item{comparison}{you can run mxCompare on a comparison model (NULL)}

\item{CIs}{Whether to show Confidence intervals if they exist (TRUE)}

\item{zero.print}{How to show zeros (".")}

\item{report}{If "html", then open an html table of the results.}

\item{...}{Other parameters to control model summary}
}
\value{
- optional \code{\link{mxModel}}
}
\description{
Summarise a Cholesky model as returned by umxACEcov
}
\examples{
require(umx)
data(twinData)
labList = c("MZFF", "MZMM", "DZFF", "DZMM", "DZOS")
twinData$ZYG = factor(twinData$zyg, levels = 1:5, labels = labList)
selDVs = c("bmi1", "bmi2")
mzData <- subset(twinData, ZYG == "MZFF", selDVs)
dzData <- subset(twinData, ZYG == "DZFF", selDVs)
m1 = umxACE(selDVs = selDVs, dzData = dzData, mzData = mzData)
m1 = umxRun(m1)
umxSummaryACE(m1)
\dontrun{
umxSummaryACE(m1, file = NA);
umxSummaryACE(m1, file = "name", std = TRUE)
stdFit = umxSummaryACE(m1, returnStd = TRUE);
}
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
- \code{\link{umxACEcov}}

Other Twin Modeling Functions: \code{\link{plot.MxModel}},
  \code{\link{umxACESexLim}}, \code{\link{umxACEcov}},
  \code{\link{umxACE}}, \code{\link{umxCF_SexLim}},
  \code{\link{umxCP}}, \code{\link{umxGxE_window}},
  \code{\link{umxGxE}}, \code{\link{umxIP}},
  \code{\link{umxPlotACEcov}}, \code{\link{umxPlotCP}},
  \code{\link{umxPlotGxE}}, \code{\link{umxPlotIP}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umx_make_TwinData}}, \code{\link{umx}}
}

