% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_make_TwinData}
\alias{umx_make_TwinData}
\title{umx_make_TwinData}
\usage{
umx_make_TwinData(nMZpairs, nDZpairs, a = c(avg = 0.5, min = 0, max = 1), c,
  e)
}
\arguments{
\item{nMZpairs}{Number of MZ pairs to simulate}

\item{nDZpairs}{Number of DZ pairs to simulate}

\item{a}{value for a, defaults to an example of moderation: c(avg=.5, min=0, max=1)}

\item{c}{value for c}

\item{e}{value for e}
}
\value{
- list of mzData and dzData data.frames
}
\description{
Makes MZ and DZ twin data, optionally moderated.
}
\details{
You supply the number of pairs of each zygosity that wish to simulate (nMZpairs, nDZpairs), along with the values of a, c,and e.
a can take a list of values which if specified will act like a moderated heritability, with average value a[1], and swinging
down to a[2 and up to a[3] across 4-SDs of the moderator.
}
\examples{
str(umx_make_TwinData(100,100, .5, .3, .4))
}
\references{
- \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
\seealso{
Other Twin Modeling Functions: \code{\link{plot.MxModel}},
  \code{\link{umxACESexLim}}, \code{\link{umxACEcov}},
  \code{\link{umxACE}}, \code{\link{umxCF_SexLim}},
  \code{\link{umxCP}}, \code{\link{umxGxE_window}},
  \code{\link{umxGxE}}, \code{\link{umxIP}},
  \code{\link{umxPlotACEcov}}, \code{\link{umxPlotCP}},
  \code{\link{umxPlotGxE}}, \code{\link{umxPlotIP}},
  \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umx}}
}

