% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{txt_contains}
\alias{txt_contains}
\title{Check if text contains a certain pattern}
\usage{
txt_contains(x, patterns, value = FALSE, ignore.case = TRUE, ...)
}
\arguments{
\item{x}{a character vector with text}

\item{patterns}{a regular expression which might be contained in \code{x}, a vector of these
or a list of pattern elements where the list elements \code{include} and \code{exclude} indicate to find a pattern in \code{x}
while excluding elements which have another pattern}

\item{value}{logical, indicating to return the elements of \code{x} where the pattern was found or just a logical vector. Defaults to FALSE indicating to return a logical.}

\item{ignore.case}{logical, if set to \code{FALSE}, the pattern matching is case sensitive and if TRUE, case is ignored during matching. Passed on to \code{\link{grepl}}}

\item{...}{other parameters which can be passed on to \code{\link{grepl}} e.g. fixed/perl/useBytes}
}
\value{
a logical vector of the same length as \code{x} indicating if one of the patterns was found in \code{x}.\cr 
Or the vector of elements of \code{x} where the pattern was found in case argument \code{value} is set to \code{TRUE}
}
\description{
Look up text which has a certain pattern. This pattern lookup is performed by executing a regular expression using \code{\link{grepl}}.
}
\examples{
x <- c("The cats are eating catfood", 
       "Our cat is eating the catfood", 
       "the dog eats catfood, he likes it")
txt_contains(x, patterns = c("cat", "dog")) 
txt_contains(x, patterns = c("cat", "dog"), value = TRUE) 
txt_contains(x, patterns = c("eats"), value = TRUE) 
txt_contains(x, patterns = c("^The"), ignore.case = FALSE, value = TRUE) 
txt_contains(x, patterns = list(include = c("cat"), exclude = c("dog")), 
             value = TRUE) 
txt_contains(x, "cat") & txt_contains(x, "dog")
}
\seealso{
\code{\link{grepl}}
}
