% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ucsf_api.R
\name{IndustryDocsSearch}
\alias{IndustryDocsSearch}
\title{UCSF Industry Documents Library Solr API}
\description{
UCSF Industry Documents Library Solr API

UCSF Industry Documents Library Solr API
}
\examples{

## ------------------------------------------------
## Method `IndustryDocsSearch$save`
## ------------------------------------------------

ids = IndustryDocsSearch$new()
ids$query(
  industry='tobacco',
  case='State of North Carolina',
  collection='JUUL labs Collection',
  n=100)
ids$save('query_results.csv', format='csv')
file.remove('query_results.csv')
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{results}}{placeholder for storing query results}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-IndustryDocsSearch-new}{\code{IndustryDocsSearch$new()}}
\item \href{#method-IndustryDocsSearch-query}{\code{IndustryDocsSearch$query()}}
\item \href{#method-IndustryDocsSearch-save}{\code{IndustryDocsSearch$save()}}
\item \href{#method-IndustryDocsSearch-clone}{\code{IndustryDocsSearch$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IndustryDocsSearch-new"></a>}}
\if{latex}{\out{\hypertarget{method-IndustryDocsSearch-new}{}}}
\subsection{Method \code{new()}}{
Create a new IndustryDocsSearch instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IndustryDocsSearch$new()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{NONE}}{No parameters for initialization}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IndustryDocsSearch-query"></a>}}
\if{latex}{\out{\hypertarget{method-IndustryDocsSearch-query}{}}}
\subsection{Method \code{query()}}{
Query the UCSF Industry Documents Solr Library
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IndustryDocsSearch$query(
  q = NULL,
  case = NULL,
  collection = NULL,
  doc_type = NULL,
  industry = NULL,
  brand = NULL,
  availability = NULL,
  date = NULL,
  id = NULL,
  author = NULL,
  source = NULL,
  bates = NULL,
  box = NULL,
  originalformat = NULL,
  wt = "json",
  cursor_mark = "*",
  sort = "id\%20asc",
  n = 1000
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{The query text that may incoporate the rest of the parameters. The function will not use the rest of the parameters if \code{q} is not NULL.}

\item{\code{case}}{The case the collection is related to.}

\item{\code{collection}}{The collection the results are found in.}

\item{\code{doc_type}}{The document type(s) to filter the results.}

\item{\code{industry}}{The industry the documents are located within.}

\item{\code{brand}}{The brand the documents are related to.}

\item{\code{availability}}{The availability status of the documents.}

\item{\code{date}}{The date of the documents.}

\item{\code{id}}{The id of the document(s).}

\item{\code{author}}{The author or originator of the contents of the document(s).}

\item{\code{source}}{The source of the document(s); usually the institution that deposited the documents.}

\item{\code{bates}}{The bates number(s) of the document(s) to be retrieved.}

\item{\code{box}}{The box id of the document(s) to be retrieved.}

\item{\code{originalformat}}{The original format of the document(s) to be retrieved.}

\item{\code{wt}}{The format the results should come in. Defaults to json. Functions depend on the results being returned as a JSON object.}

\item{\code{cursor_mark}}{Initial placeholder for cursormark within the API URL}

\item{\code{sort}}{The results will be sorted by ID in ascending order.}

\item{\code{n}}{The number of results we want to capture. Defaults to 1000. If \code{n} is set to \code{-1} then all documents available related to the query will be retrieved.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IndustryDocsSearch-save"></a>}}
\if{latex}{\out{\hypertarget{method-IndustryDocsSearch-save}{}}}
\subsection{Method \code{save()}}{
Save results to file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IndustryDocsSearch$save(filename, format)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filename}}{Output filename}

\item{\code{format}}{Output format ('parquet' or 'json' or 'csv')}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ids = IndustryDocsSearch$new()
ids$query(
  industry='tobacco',
  case='State of North Carolina',
  collection='JUUL labs Collection',
  n=100)
ids$save('query_results.csv', format='csv')
file.remove('query_results.csv')
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IndustryDocsSearch-clone"></a>}}
\if{latex}{\out{\hypertarget{method-IndustryDocsSearch-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IndustryDocsSearch$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
