% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utest_class.R
\name{utest_classify}
\alias{utest_classify}
\title{Test for classification of a sample in one of two groups.}
\usage{
utest_classify(x, data, group_id, bootstrap_iter = 1000)
}
\arguments{
\item{x}{A numeric vector to be classified.}

\item{data}{Data matrix. Each row represents an observation.}

\item{group_id}{A vector of 0s (first group) and 1s indicating to which group the samples belong. Must be in the same order as data.}

\item{bootstrap_iter}{Numeric scalar. The number of bootstraps. It's recommended
\eqn{1000 < bootstrap_iter < 10000}.}
}
\value{
A list with class "utest_classify" containing the following components:
    \item{statistic}{the value of the test statistic.}
    \item{p_value}{The p-value for the test.}
    \item{bootstrap_iter}{the number of bootstrap iterations.}
}
\description{
The null hypothesis is that the new data is not well classified into the first group when compared to the second group. The
alternative hypothesis is that the data is well classified into the first group.
}
\details{
The test is performed considering the squared Euclidean distance.

For more detail see Cybis, Gabriela B., Marcio Valk, and Sílvia RC Lopes. "Clustering and classification problems in genetics through U-statistics."
Journal of Statistical Computation and Simulation 88.10 (2018)
and Valk, Marcio, and Gabriela Bettella Cybis. "U-statistical inference for hierarchical clustering." arXiv preprint arXiv:1805.12179 (2018).
}
\examples{
# Example 1
# Five observations from each group, G1 and G2. Each observation has 60 dimensions.
data <- matrix(c(rnorm(300, 0), rnorm(300, 10)), ncol = 60, byrow=TRUE)
# Test data comes from G1.
x <- rnorm(60, 0)
# The test correctly indicates that the test data should be classified into G1 (p < 0.05).
utest_classify(x, data, group_id = c(rep(0,times=5),rep(1,times=5)))

# Example 2
# Five observations from each group, G1 and G2. Each observation has 60 dimensions.
data <- matrix(c(rnorm(300, 0), rnorm(300, 10)), ncol = 60, byrow=TRUE)
# Test data comes from G2.
x <- rnorm(60, 10)
# The test correctly indicates that the test data should be classified into G2 (p > 0.05).
utest_classify(x, data, group_id = c(rep(1,times=5),rep(0,times=5)))
}
