% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_set_tt_rate}
\alias{system_set_tt_rate}
\title{Actual Function Called by \code{SI_TT_RATE}}
\usage{
system_set_tt_rate(
  cfg,
  rate,
  times,
  levels,
  tt_ts,
  tsinfo,
  repdose = "none",
  interval = 1,
  number = 0
)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{rate}{name of the infusion rate to update(Defined in \code{<R:?>})}

\item{times}{vector of switching times relative to the current titration time (in time units defined by \code{<R:?>})}

\item{levels}{vector of infusion rates (in dosing units defined by \code{<R:?>})}

\item{tt_ts}{list of timescale values for the current titration time}

\item{tsinfo}{list with timescale information for inputs (bolus, rates, etc)}

\item{repdose}{\code{"none"} or \code{"sequence"}}

\item{interval}{interval to repeat in the units defined in \code{<R:?>}}

\item{number}{number of times to repeat}
}
\value{
ubiquity system object with the infusion rates updated.
}
\description{
The prototype function \code{SI_TT_RATE} provides an abstract interface to this function. Based on the input from \code{SI_TT_RATE}
infusion rate inputs will be updated for the current titration time.
}
