% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_define_cohort}
\alias{system_define_cohort}
\title{Define Estimation Cohort}
\usage{
system_define_cohort(cfg, cohort)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{cohort}{list with cohort information}
}
\value{
ubiquity system object with cohort defined
}
\description{
Define a cohort to include in a parameter estimation
}
\details{
Each cohort has a name (eg \code{d5mpk}), and the dataset containing the
information for this cohort is identified (the name defined in \code{\link{system_load_data}})

\preformatted{cohort  = c()
cohort$name    = "d5mpk"
cohort$dataset = "pmdata"}

Next it is necessary to define a filter (\code{cf} field) that can be
applied to the dataset to only return values relevant to this cohort. For
example, if we only want records where the column \code{DOSE} is 5 (for the 5
mpk cohort). We can 
\preformatted{cohort$cf$DOSE = c(5)}

If the dataset has the headings \code{ID}, \code{DOSE} and \code{SEX}  and
cohort filter had the following format:
\preformatted{cohort$cf$ID   = c(1:4)

cohort$cf$DOSE = c(5,10)
cohort$cf$SEX  = c(1)}

It would be translated into the boolean filter:

\preformatted{(ID==1) | (ID==2) | (ID==3) | (ID==4)) & ((DOSE == 5) | (DOSE==10)) & (SEX == 1)}

Optionally you may want to fix a system parameter to a different value for a
given cohort. This can be done using the cohort parameter (\code{cp}) field.
For example if you had the body weight defined as a system parameter 
(\code{BW}), and you wanted to fix the body weight to 70 for the current
cohort you would do the following:

\preformatted{cohort$cp$BW = 70}

Note that you can only fix parameters that are not being estimated.

Next we define the dosing for this cohort. It is only necessary to define
those inputs that are non-zero. So if the data here were generated from
animals given a single 5 mpk IV at time 0. If in the model this was defined
using \code{<B:times>} and \code{<B:events>} dosing into the central
compartment \code{Cp}, you would pass this information to the cohort in the
following manner:

\preformatted{cohort$inputs$bolus$Cp$AMT   = c(5)
cohort$inputs$bolus$Cp$TIME  = c(0)}
 
Inputs can also include any infusion rates (\code{infusion_rates}) or
covariates (\code{covariates}). Covariates will have the default value
specified in the system file unless overwritten here. The units here are
the same as those in the system file
 
Next we need to map the outputs in the model to the observation data in the
dataset. Under \code{cohort.outputs} there is a field for each output. Here the field \code{ONAME}
can be replaced with something more useful (like \code{PK}). The times and
observations in the dataset are found in the \code{’TIMECOL’} column and the \code{’OBSCOL’} column
(optional missing data option specified by -1). These are mapped to the model outputs (which
MUST have the same units) ’TS’ and ’MODOUTPUT'. The variance model
\code{'VARMOD'} is a string containing the variance model written in terms
of the model prediction (\code{PRED}), variance parameters (defined with
\code{<VP>} in the system file), and numbers. To do a least squares

\preformatted{cohort$outputs$ONAME$obs$time        = ’TIMECOL’      
cohort$outputs$ONAME$obs$value       = ’OBSCOL’       
cohort$outputs$ONAME$obs$missing     = -1         
cohort$outputs$ONAME$model$time      = ’TS'       
cohort$outputs$ONAME$model$value     = ’MODOUTPUT’  
cohort$outputs$ONAME$model$variance  = ’VARMOD'}

\bold{Note: Output names should be consistent between cohorts so they will be grouped together when plotting results.}

Optionally we can add information about the markers to use when plotting
the output for this cohort:
\preformatted{cohort$outputs$ONAME$options$marker_color   = 'black'
cohort$outputs$ONAME$options$marker_shape   = 16
cohort$outputs$ONAME$options$marker_line    = 1 }

Lastly we define the cohort:
}
\seealso{
Estimation vignette (\code{vignette("Estimation", package = "ubiquity")}) and \code{\link{system_select_set}}
}
