% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMethods.R, R/printMethods.R,
%   R/quantileResidualTests.R
\name{plot.qrtest}
\alias{plot.qrtest}
\alias{print.qrtest}
\alias{quantileResidualTests}
\title{Quantile residual tests for GMAR, StMAR or G-StMAR model}
\usage{
\method{plot}{qrtest}(x, ...)

\method{print}{qrtest}(x, ..., digits = 3)

quantileResidualTests(gsmar, lagsAC = c(1, 2, 5, 10), lagsCH = lagsAC,
  nsimu = 2000, printRes = TRUE)
}
\arguments{
\item{x}{object of class \code{'qrtest'} created with the function \code{quantileResidualTests}.}

\item{...}{graphical parameters passed to \code{segments} in \code{plot.qrtest}.
Currectly not used in \code{print.qrtest}}

\item{digits}{number of decimals to print}

\item{gsmar}{object of class \code{'gsmar'} created with the function \code{fitGSMAR} or \code{GSMAR}.}

\item{lagsAC}{a numeric vector of positive integers specifying the lags for which autocorrelation is tested.}

\item{lagsCH}{a numeric vector of positive integers specifying the lags for which conditional heteroscedasticity is tested.}

\item{nsimu}{a positive integer specifying to how many simulated observations the covariance matrix Omega
(see Kalliovirta (2012)) should be based on. If smaller than data size, then omega will be based on the given data.}

\item{printRes}{a logical argument defining whether results should be printed or not.}
}
\value{
Returns an object of class \code{'qrtest'} containing the test results in data frames. In the cases
  of autocorrelation and conditional heteroscedasticity tests, the returned object also contains the
  associated individual statistics and their standard errors, discussed by \emph{Kalliovirta (2012)} at
  the pages 369-370.
}
\description{
\code{quantileResidualTests} performs quantile residual tests for GMAR, StMAR or G-StMAR model,
 testing normality, autocorrelation and conditional heteroscedasticity.
}
\details{
For details about the quantile residual tests see the cited article by \emph{Kalliovirta (2012)}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot}: plot p-values of the autocorrelation and conditional
heteroskedasticity tests.

\item \code{print}: print method for class 'qrtest'
}}

\section{Suggested packages}{

  Install the suggested package "gsl" for faster evaluations in the cases of StMAR and G-StMAR models.
  For large StMAR and G-StMAR models with large data the evaluations may take significantly long time without
  the package "gsl".
}

\examples{
\donttest{
# GMAR model
fit12 <- fitGSMAR(data=logVIX, p=1, M=2, model="GMAR")
qrtest12 <- quantileResidualTests(fit12)
plot(qrtest12)

# Restricted GMAR model
fit12r <- fitGSMAR(logVIX, 1, 2, model="GMAR", restricted=TRUE)
qrtest12r <- quantileResidualTests(fit12r, lagsAC=1:10, nsimu=1)
plot(qrtest12r)

# Non-mixture version of StMAR model
fit11t <- fitGSMAR(logVIX, 1, 1, model="StMAR", ncores=1, ncalls=1)
quantileResidualTests(fit11t, lagsAC=c(1, 2, 5), nsimu=1, printRes=FALSE)

# G-StMAR model
fit12gs <- fitGSMAR(logVIX, 1, M=c(1, 1), model="G-StMAR")
quantileResidualTests(fit12gs, lagsAC=c(1, 3), lagsCH=1:2,
 nsimu=1, printRes=FALSE)

# GMAR model as a mixture of AR(2) and AR(1) models
constraints <- list(diag(1, ncol=2, nrow=2), as.matrix(c(1, 0)))
fit22c <- fitGSMAR(logVIX, 2, 2, constraints=constraints)
quantileResidualTests(fit22c, lagsAC=c(1, 3), nsimu=1, printRes=FALSE)
}
}
\references{
\itemize{
   \item Galbraith, R., Galbraith, J. 1974. On the inverses of some patterned matrices arising
           in the theory of stationary time series. \emph{Journal of Applied Probability} \strong{11}, 63-71.
   \item Kalliovirta L. (2012) Misspecification tests based on quantile residuals.
           \emph{The Econometrics Journal}, \strong{15}, 358-393.
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Meitz M., Preve D., Saikkonen P. 2018. A mixture autoregressive model based on Student's t-distribution.
           arXiv:1805.04010 \strong{[econ.EM]}.
   \item There are currently no published references for G-StMAR model, but it's a straight forward generalization with
           theoretical properties similar to GMAR and StMAR models.
 }
}
\seealso{
\code{\link{fitGSMAR}}, \code{\link{GSMAR}}, \code{\link{diagnosticPlot}}, \code{\link{predict.gsmar}},
 \code{\link{getOmega}},
}
