% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictMethod.R
\name{predict.gsmar}
\alias{predict.gsmar}
\title{Forecast GMAR, StMAR or G-StMAR process}
\usage{
\method{predict}{gsmar}(object, ..., n_ahead, nsimu = 5000, ci = c(0.95,
  0.8), pred_type = c("mean", "median", "cond_mean"),
  ci_type = c("two-sided", "upper", "lower", "none"), nt, plotRes = TRUE)
}
\arguments{
\item{object}{object of class \code{'gsmar'}, generated by function \code{fitGSMAR()} or \code{GSMAR()}.}

\item{...}{additional arguments passed to \code{grid()} (ignored if \code{plot_res==FALSE}).}

\item{n_ahead}{a positive integer specifying how many steps in the future should be forecasted.}

\item{nsimu}{a positive integer specifying to how many simulations the forecast should be based on.}

\item{ci}{a numeric vector specifying the confidence levels of the confidence intervals.}

\item{pred_type}{should the prediction be based on sample "mean" or "median"? Or should it
be one-step-ahead forecast based on conditional mean (\code{"cond_mean"})? Confidence intervals
won't be calculated if conditional mean is used.}

\item{ci_type}{should the confidence intervals be "two-sided", "upper" or "lower"?}

\item{nt}{a positive integer specifying the number of observations to be plotted
along with the prediction. Default is \code{round(length(data)*0.2)}.}

\item{plotRes}{a logical argument defining wether the forecast should be plotted or not.}
}
\value{
Returns a data frame containing the empirical best predicton and confidence intervals accordingly to \code{ci}.
  Or if \code{pred_type=="cond_mean"} returns the optimal prediction as (1x1) numeric vector.
}
\description{
\code{forecastGSMAR} forecasts the specified GMAR, StMAR or G-StMAR process by using the given data to simulate
 its possible future values. For one-step forecasts using the exact formula of conditional mean is supported.
}
\details{
\code{forecastGSMAR} uses the last \code{p} values of the data to simulate \code{nsimu} possible
 future values for each step. The best prediction is then obtained by calculating the sample median (or mean)
 of each step and the confidence intervals are obtained from the empirical fractiles.
}
\examples{
\donttest{
# GMAR model
params12 <- c(1.12, 0.91, 0.29, 4.53, 0.70, 3.21, 0.84)
gmar12 <- GSMAR(VIX, 1, 2, params12)
pred12 <- predict(gmar12, n_ahead=10)
pred12

# Restricted GMAR model, one-step conditional mean prediction
params12r <- c(1.4, 1.8, 0.88, 0.29, 3.18, 0.84)
gmar12r <- GSMAR(data=VIX, p=1, M=2, params=params12r, model="GMAR",
 restricted=TRUE)
pred12r <- predict(gmar12r, pred_type="cond_mean", plotRes=FALSE)
pred12r

# StMAR model, upper confidence intervals
params12t <- c(1.38, 0.88, 0.27, 3.8, 0.74, 3.15, 0.8, 100, 3.6)
stmar12 <- GSMAR(data=VIX, p=1, M=2, params=params12t, model="StMAR")
predict(stmar12, n_ahead=10, ci_type="upper", ci=c(0.99, 0.95, 0.9))

# G-StMAR model, no confidence intervals
params12gs <- c(1.38, 0.88, 0.27, 3.8, 0.74, 3.15, 0.8, 3.6)
gstmar12 <- GSMAR(data=VIX, p=1, M=c(1, 1), params=params12gs,
 model="G-StMAR")
pred12gs <- predict(gstmar12, n_ahead=10, pred_type="median",
 ci_type="none", plotRes=FALSE)
pred12gs
plot(pred12gs)

# GMAR model as a mixture of AR(2) and AR(1) models
constraints <- list(diag(1, ncol=2, nrow=2), as.matrix(c(1, 0)))
params22c <- c(1.2, 0.85, 0.04, 0.3, 3.3, 0.77, 2.8, 0.77)
gmar22c <- GSMAR(data=VIX, p=2, M=2, params=params22c,
 model="GMAR", constraints=constraints)
predict(gmar22c, n_ahead=5, nsimu=10000, nt=10)

# Such StMAR(3,2) that the AR coefficients are restricted to be
# the same for both regimes and that the second AR coefficients are
# constrained to zero.
params32trc <- c(2.2, 1.8, 0.88, -0.03, 2.4, 0.27, 0.40, 3.9, 1000)
stmar32rc <- GSMAR(data=VIX, p=3, M=2, params=params32trc, model="StMAR",
 restricted=TRUE, constraints=matrix(c(1, 0, 0, 0, 0, 1), ncol=2))
predict(stmar32rc, n_ahead=3, ci_type="lower")
}
}
\seealso{
\code{\link{fitGSMAR}}, \code{\link{GSMAR}}, \code{\link{quantileResidualTests}}, \code{\link{diagnosticPlot}}
}
